#include <minix/stubs.h>
#include <signal.h>
#include <sys/types.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

/* array of funcs to catch signals */
extern sighandler_t _vectab[_NSIG];

sighandler_t signal(signr, func)
int signr;			/* which signal is being set */
sighandler_t func;		/* pointer to function that catches signal */
{
  message m;
  int r;
  sighandler_t old;

  old = _vectab[signr - 1];
  m.m6_i1 = signr;
  if (func == SIG_IGN || func == SIG_DFL)
	/* Keep old signal catcher until it is completely de-installed */
	m.m6_f1 = func;
  else {
	/* Use new signal catcher immediately (old one may not exist) */
	_vectab[signr - 1] = func;
	m.m6_f1 = _begsig;
  }

  /* Clear unused fields */
  m.m6_i2 = 0;
  m.m6_i3 = 0;
  m.m6_l1 = 0;

  r= _syscall(PROC_MM, SIGNAL, &m);
  if (r < 0) {
	_vectab[signr - 1] = old;/* undo any pre-installation */
	return (sighandler_t)r;
  }
  _vectab[signr - 1] = func;	/* redo any pre-installation */
  if (r == 1) return(SIG_IGN);
  return(old);
}

/*
 * $PchId: _signal.c,v 1.4 1995/11/27 19:44:14 philip Exp $
 */
