/*
syscall/_open.c
*/

#include <minix/stubs.h>
#include <fcntl.h>
#include <string.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

#if _ANSI
#include <stdarg.h>

int open(const char *name, int flags, ...)
{
	int i;
	va_list ap;
	message m;

	if (flags & O_CREAT) {
		va_start(ap, flags);
		i = va_arg(ap, int);

		m.m1_i1 = strlen(name)+1;
		m.m1_i2 = flags;
		m.m1_i3 = i;
		m.m1_p1 = (char *)name;

		/* Clear unused fields */
		m.m1_p2 = NULL;
		m.m1_p3 = NULL;

		va_end(ap);

		return _syscall(PROC_FS, OPEN, &m);
	}

	/* m.m3_i1 filled in by _m3_loadname */
	m.m3_i2 = flags;
	/* m.m3_p1 filled in by _m3_loadname */
	/* m.m3_ca1 filled in by _m3_loadname */
	_m3_loadname(&m, name);

	return _syscall(PROC_FS, OPEN, &m);
}
#else
int open(name, flags, mode)
_CONST char *name;
int flags, mode;
{
	message m;

	if (flags & O_CREAT)
	{
		m.m1_i1 = strlen(name)+1;
		m.m1_i2 = flags;
		m.m1_i3 = mode;
		m.m1_p1 = (char *)name;

		/* Clear unused fields */
		m.m1_p2 = NULL;
		m.m1_p3 = NULL;

		return _syscall(PROC_FS, OPEN, &m);
	}
	/* m.m3_i1 filled in by _m3_loadname */
	m.m3_i2 = flags;
	/* m.m3_p1 filled in by _m3_loadname */
	/* m.m3_ca1 filled in by _m3_loadname */
	_m3_loadname(&m, name);

	return _syscall(PROC_FS, OPEN, &m);
}
#endif

/*
 * $PchId: _open.c,v 1.4 1995/11/27 19:48:53 philip Exp $
 */
