/*
syscall/_nice.c

Created:	May 1995 by Philip Homburg <philip@cs.vu.nl>
*/

#define _MINIX_SOURCE

#include <minix/stubs.h>
#include <unistd.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

int nice(incr)
int incr;
{
	message m;
	int r;

	m.m1_i1 = 0;		/* Allow expansion to setpriority */
	m.m1_i2 = incr;

	/* Clear unused fields */
	m.m1_i3 = 0;
	m.m1_p1 = NULL;
	m.m1_p2 = NULL;
	m.m1_p3 = NULL;

	r= _syscall(PROC_MM, NICE, &m);
	if (r == -1)
		return r;
	return m.m1_i1;
}

/*
 * $PchId: _nice.c,v 1.2 1996/02/22 09:05:58 philip Exp $
 */
