/*
syscall/_mknod.c

Created:	June 10, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#define _MINIX_SOURCE

#include <minix/stubs.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

int mknod(name, mode, addr)
_CONST char *name;
mode_t mode;
dev_t addr;
{
	message m;

	m.m1_i1 = strlen(name)+1;
	m.m1_i2 = mode;
	m.m1_i3 = addr;
	m.m1_p1 = (char *)name;

	/* Clear unused fields */
	m.m1_p2 = NULL;
	m.m1_p3 = NULL;

	return _syscall(PROC_FS, MKNOD, &m);
}

/*
 * $PchId: _mknod.c,v 1.4 1995/11/27 19:49:58 philip Exp $
 */
