/*
syscall/_lseek.c

Created:	June 7, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include <minix/stubs.h>
#include <unistd.h>
#include <sys/types.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

off_t lseek(fd, offset, whence)
int fd;
off_t offset;
int whence;
{
	message m;
	int r;

	m.m2_i1 = fd;
	m.m2_i2 = whence;
	m.m2_l1 = offset;

	/* Clear unused fields */
	m.m2_i3 = 0;
	m.m2_l2 = 0;
	m.m2_p1 = NULL;

	r= _syscall(PROC_FS, LSEEK, &m);
	if (r == -1)
		return r;
	return m.m2_l1;
}

/*
 * $PchId: _lseek.c,v 1.4 1995/11/27 19:52:49 philip Exp $
 */
