/*
syscall/_getppid.c

Created:	June 8, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include <minix/stubs.h>
#include <unistd.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

int getppid()
{
	message m;
	int r;

	/* Clear unused fields */
	m.m1_i1 = 0;
	m.m1_i2 = 0;
	m.m1_i3 = 0;
	m.m1_p1 = NULL;
	m.m1_p2 = NULL;
	m.m1_p3 = NULL;

	r = _syscall(PROC_MM, GETPID, &m);
	if (r == -1)
		return -1;
  
	return m.m2_i1;
}

/*
 * $PchId: _getppid.c,v 1.4 1995/11/27 19:54:28 philip Exp $
 */
