/*	_getgroups() - get supplementary groups		Author: Kees J. Bot
 *								17 Jan 1994
 */

#include <minix/stubs.h>
#include <sys/types.h>
#include <unistd.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>
#include <errno.h>

int getgroups(int gidsetlen, gid_t *gidset)
{
	message m;
	int i;
	int gid;

	for (i = 0; ; i++) {
		m.m1_i1 = 0;
		m.m1_i2 = i;

		/* Clear unused fields */
		m.m1_i3 = 0;
		m.m1_p1 = NULL;
		m.m1_p2 = NULL;
		m.m1_p3 = NULL;

		if ((gid = _syscall(PROC_MM, GSGROUPS, &m)) == -1) {
			if (errno != ESRCH) return -1;
			break;
		}
		if (i < gidsetlen) gidset[i] = gid;
	}
	errno = EINVAL;
	return gidsetlen == 0 || i <= gidsetlen ? i : -1;
}

/*
 * $PchId: _getgroups.c,v 1.4 1995/11/27 19:55:51 philip Exp $
 */
