/*
syscall/_chown.c

Created:	June 8, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include <minix/stubs.h>
#include <string.h>
#include <unistd.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

int chown(name, owner, grp)
_CONST char *name;
int owner, grp;
{
	message m;

	m.m1_i1 = strlen(name)+1;
	m.m1_i2 = owner;
	m.m1_i3 = grp;
	m.m1_p1 = (char *)name;
	
	/* Clear unused fields */
	m.m1_p2 = NULL;
	m.m1_p3 = NULL;

	return _syscall(PROC_FS, CHOWN, &m);
}

/*
 * $PchId: _chown.c,v 1.4 1995/11/27 19:58:38 philip Exp $
 */
