/*
syscall/_brk.c

Created:	June 7, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#define _MINIX_SOURCE

#include <minix/stubs.h>
#include <unistd.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

extern char *_brksize;

int brk(addr)
char *addr;
{
	message m;
	int r;

	m.m1_p1 = addr;

	/* Clear unused fields */
	m.m1_i1 = 0;
	m.m1_i2 = 0;
	m.m1_i3 = 0;
	m.m1_p2 = NULL;
	m.m1_p3 = NULL;

	r= _syscall(PROC_MM, BRK, &m);
	if (r == -1)
		return -1;
	_brksize= addr;
	return 0;
}


char *sbrk(incr)
int incr;
{
	char *newsize, *oldsize;

	oldsize = _brksize;
	newsize = _brksize + incr;
	if ((incr > 0 && newsize < oldsize) || (incr < 0 && newsize > oldsize))
		return (char *) -1;
	if (_brk(newsize) == 0)
		return oldsize;
	else
		return (char *) -1;
}

/*
 * $PchId: _brk.c,v 1.4 1995/11/27 20:00:16 philip Exp $
 */
