/*	uname(3) - describe the machine.		Author: Kees J. Bot
 *								5 Dec 1992
 */

#define _POSIX_SOURCE
#define _MINIX_SOURCE

#include <minix/stubs.h>
#include <sys/types.h>
#include <sys/utsname.h>

#define uts_get(field, string) \
	if (sysuname(_UTS_GET, field, name->string, sizeof(name->string)) < 0) \
		return -1; \
	name->string[sizeof(name->string)-1]= 0;

int uname(name)
struct utsname *name;
{
	/* Get each of the strings with a sysuname call.  Null terminate them,
	 * because the buffers in the kernel may grow before this and the
	 * programs are recompiled.
	 */
	uts_get(_UTS_SYSNAME, sysname);
	uts_get(_UTS_NODENAME, nodename);
	uts_get(_UTS_RELEASE, release);
	uts_get(_UTS_VERSION, version);
	uts_get(_UTS_MACHINE, machine);
	uts_get(_UTS_ARCH, arch);
	uts_get(_UTS_KERNEL, kernel);
	uts_get(_UTS_HOSTNAME, hostname);
	uts_get(_UTS_BUS, bus);
	return 0;
}

/*
 * $PchId: _uname.c,v 1.4 1995/11/27 20:09:08 philip Exp $
 */
