/*
posix/_tcsetattr.c

Created:	June 11, 1993 by Philip Homburg
*/

#include <minix/stubs.h>
#include <errno.h>
#include <termios.h>
#include <sys/ioctl.h>
#include <sys/types.h>

int tcsetattr(fd, opt_actions, termios_p)
int fd;
int opt_actions;
_CONST struct termios *termios_p;
{
	switch(opt_actions)
	{
	case TCSANOW:	return ioctl(fd, TCSETS, termios_p);
	case TCSADRAIN:	return ioctl(fd, TCSETSW, termios_p);
	case TCSAFLUSH:	return ioctl(fd, TCSETSF, termios_p);
	default:	errno= EINVAL; return -1;
	};
}

/*
 * $PchId: _tcsetattr.c,v 1.4 1995/11/27 20:09:34 philip Exp $
 */
