/*
libc/os/minix/posix/_system.c

Implementation of system() based on the sample code in the POSIX 1003.2
draft 11.2, figure B-1

Created:	Oct 7, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#define _POSIX_SOURCE

#include <minix/stubs.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>

int system(cmd)
const char *cmd;
{
	struct sigaction saveintr, savequit, sa;
	int restore_sigint= 0, restore_sigquit= 0, restore_procmask= 0;
	sigset_t procmask, saveblock;
	pid_t pid;
	int r, saveerrno;

	if (cmd == NULL)
		return 1;

	r= 0;
	sa.sa_handler= SIG_IGN;
	if (r != -1) r= sigemptyset(&sa.sa_mask);
	sa.sa_flags= 0;
	if (r != -1) r= sigemptyset(&saveintr.sa_mask);
	if (r != -1) r= sigemptyset(&savequit.sa_mask);
	if (r != -1)
	{
		r= sigaction(SIGINT, &sa, &saveintr);
		if (r != -1)
			restore_sigint= 1;
	}
	if (r != -1)
	{
		r= sigaction(SIGQUIT, &sa, &savequit);
		if (r != -1)
			restore_sigquit= 1;
	}
	if (r != -1) r= sigemptyset(&procmask);
	if (r != -1) r= sigaddset(&procmask, SIGCHLD);
	if (r != -1) r= sigemptyset(&saveblock);
	if (r != -1)
	{
		r= sigprocmask(SIG_BLOCK, &procmask, &saveblock);
		if (r != -1)
			restore_procmask= 1;
	}

	if (r != -1)
	{
		pid= fork();
		if (pid == 0)
		{
			if (r != -1) r= sigaction(SIGINT, &saveintr, 
				(struct sigaction *)0);
			if (r != -1) r= sigaction(SIGQUIT, &savequit, 
				(struct sigaction *)0);
			if (r != -1) r= sigprocmask(SIG_SETMASK, &saveblock, 
				(sigset_t *)0);
			if (r != -1)
			{
				execl("/bin/sh", "sh", "-c", cmd, (char *)0);
				execl("/usr/bin/sh", "sh", "-c", cmd,
					(char *)0);
				execl("/sbin/sh", "sh", "-c", cmd, (char *)0);
				execl("/usr/sbin/sh", "sh", "-c", cmd,
					(char *)0);
			}
			_exit(127);
		}
		if (pid == -1)
			r= -1;
		else
		{
			while(waitpid(pid, &r, 0) == -1)
			{
				if (errno != EINTR)
				{
					r= -1;
					break;
				}
			}
		}
	}
	if (r == -1)
		saveerrno= errno;
	if (restore_sigint)
		sigaction(SIGINT, &saveintr, (struct sigaction *)0);
	if (restore_sigquit)
		sigaction(SIGQUIT, &savequit, (struct sigaction *)0);
	if (restore_procmask)
		sigprocmask(SIG_SETMASK, &saveblock, (sigset_t *)0);
	if (r == -1)
		errno= saveerrno;
	return r;
}

/*
 * $PchId: _system.c,v 1.4 1995/11/27 20:10:50 philip Exp $
 */
