#define _POSIX_SOURCE

#include <minix/stubs.h>
#include <errno.h>
#include <limits.h>
#include <signal.h>

/* mask of valid signals (0 - _NSIG) */
#define SIGMASK (ULONG_MAX >> (32 - _NSIG - 1))

#define sigisvalid(signo) ((signo) >= 0 && (signo) <= _NSIG)

#if __STDC__
#define CONST const
#else
#define CONST
#endif

int sigaddset(set, signo)
sigset_t *set;
int signo;
{
  if (!sigisvalid(signo)) {
  	errno = EINVAL;
	return -1;
  }
  *set |= 1UL << signo;
  return 0;
}

int sigdelset(set, signo)
sigset_t *set;
int signo;
{
  if (!sigisvalid(signo)) {
  	errno = EINVAL;
	return -1;
  }
  *set &= ~(1UL << signo);
  return 0;
}

int sigemptyset(set)
sigset_t *set;
{
  *set = 0;
  return 0;
}

int sigfillset(set)
sigset_t *set;
{
  *set = ~0UL & SIGMASK;
  return 0;
}

int sigismember(set, signo)
CONST sigset_t *set;
int signo;
{
  if (!sigisvalid(signo)) {
  	errno = EINVAL;
	return -1;
  }
  if (*set & (1UL << signo))
  	return 1;
  return 0;
}

/*
 * $PchId: _sigset.c,v 1.4 1995/11/27 20:11:43 philip Exp $
 */
