/*
 * "nlist.c", Peter Valkenburg, january 1989.
 *
 * Modified by Philip Homburg <philip@cs.vu.nl> to use read_nlist()
 */
 
#include <nlist.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
 * Nlist fills fields n_sclass and n_value of array nl with values found in
 * non-stripped executable file.  Entries that are not found have their
 * n_value/n_sclass fields set to 0.  Nl ends with a 0 or nul string n_name.
 * The return value is -1 on failure, else the number of entries not found.
 */
int nlist(file, nl)
const char *file;
struct nlist nl[];
{
	int nsrch, nfound, i, j, exec_nlents;
	struct nlist *exec_nl, *entp;

	exec_nlents= read_nlist(file, &exec_nl);
	if (exec_nlents == -1)
		return -1;

	/* determine number of entries searched for & reset fields */
	nsrch = 0;
	while (nl[nsrch].n_name != NULL && *(nl[nsrch].n_name) != '\0') {
		nl[nsrch].n_value = 0;
		nl[nsrch].n_type = 0;		/* for compatability */
		nsrch++;
	}

	/* loop through namelist & fill in user array */
	nfound = 0;
	for (i= 0, entp = exec_nl; i<exec_nlents; i++, entp++) {
		if (nsrch == nfound)
			break;			/* no need to look further */
		for (j = 0; j < nsrch; j++)
			if (nl[j].n_type == 0 &&
			    strcmp(nl[j].n_name, entp->n_name) == 0) {
				nl[j].n_value = entp->n_value;
				nl[j].n_type = entp->n_type;
				nfound++;
				break;
			}
	}

	free(exec_nl);

	return nsrch - nfound;
}

/*
 * $PchId: nlist.c,v 1.3 1995/11/27 20:21:06 philip Exp $
 */
