/*	lockf() - file locking				Author: Kees J. Bot
 *								17 Apr 1994
 */
#include <minix/stubs.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

int lockf(int fd, int cmd, off_t size)
{
	struct flock how;
	int r;
	int flags;

	switch (cmd) {
	case F_ULOCK:
		flags= F_SETLK;
		how.l_type= F_UNLCK;
		break;
	case F_LOCK:
		flags= F_SETLKW;
		how.l_type= F_WRLCK;
		break;
	case F_TLOCK:
		flags= F_SETLK;
		how.l_type= F_WRLCK;
		break;
	case F_TEST:
		flags= F_GETLK;
		how.l_type= F_WRLCK;
		break;
	default:
		errno= EINVAL;
		return -1;
	}
	how.l_whence= SEEK_CUR;
	how.l_start= 0;
	how.l_len= size;

	r= fcntl(fd, flags, &how);

	if (cmd == F_TEST && r == 0 && how.l_type != F_UNLCK) {
		errno= EACCES;
		r= -1;
	}
	return r;
}

/*
 * $PchId: lockf.c,v 1.3 1995/11/27 20:21:21 philip Exp $
 */
