/*	initgroups() - initialize supplementary group id list from /etc/group
 *							Author: Kees J. Bot
 *								22 Jan 1994
 */

#define _MINIX_SOURCE
#define _POSIX_SOURCE

#define nil 0
#include <minix/stubs.h>
#include <grp.h>
#include <unistd.h>
#include <limits.h>
#include <string.h>
#include <sys/types.h>

int initgroups(const char *name, Gid_t basegid)
{
	int g, i;
	struct group *grp;
	gid_t groups[NGROUPS_MAX];

	g= 0;
	groups[g++]= basegid;

	setgrent();
	while (g < NGROUPS_MAX && (grp= getgrent()) != nil) {
		if (grp->gr_gid == basegid) continue;

		for (i= 0; grp->gr_mem[i] != nil; i++) {
			if (strcmp(grp->gr_mem[i], name) == 0) {
				groups[g++]= grp->gr_gid;
				break;
			}
		}
	}
	endgrent();
	return setgroups(g, groups);
}

/*
 * $PchId: initgroups.c,v 1.4 1995/11/27 20:21:36 philip Exp $
 */
