/*	ftruncate, truncate(3) - truncate a file	Author: Kees J. Bot
 *								31 Jul 1994
 */

#define _MINIX_SOURCE

#include <minix/stubs.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

int ftruncate(int fd, off_t size)
/* Truncate an open file to a given length. */
{
	struct flock flock;

	flock.l_whence= SEEK_SET;
	flock.l_start= size;
	flock.l_len= 0;
	return fcntl(fd, F_FREESP, &flock);
}

int truncate(const char *file, off_t size)
/* Truncate a named file to a given length. */
{
	int fd;
	struct stat st;
	int r, err;

	if (stat(file, &st) < 0) return -1;
	if (!S_ISREG(st.st_mode)) { errno= EINVAL; return -1; }
	if ((fd= open(file, O_WRONLY)) < 0) return -1;
	r= ftruncate(fd, size);
	err= errno;
	(void) close(fd);
	errno= err;
	return r;
}

/*
 * $PchId: ftruncate.c,v 1.3 1995/11/27 20:23:33 philip Exp $
 */
