/*
errno/strerror.c

Created:	June 29, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include	"errlist.h"

char *strerror(int errnum)
{
	const struct errlist *listp;
	static char unknown[6 + 1 + 3 * sizeof(errnum)]= "Error N";
	unsigned e;
	char *p;

	for (listp= __sys_errlist; listp->err_string; listp++)
	{
		if (listp->err_no == errnum)
			return listp->err_string;
	}
	p= unknown + sizeof(unknown) - 1;
	e= errnum < 0 ? -errnum : errnum;
	do {
		*--p= '0' + e % 10;
		e/= 10;
	} while (e > 0);
	if (errnum < 0) *--p= '-';
	strcpy(unknown + 6, p);
	return unknown;
}

/*
 * $PchId: strerror.c,v 1.3 1995/11/27 20:27:54 philip Exp $
 */
