/* memcspn - find length of initial segment of s consisting entirely
 * of characters not from reject
 */

#define _MINIX_SOURCE

#include <string.h>

size_t memcspn(s, size_s, reject, size_reject)
_CONST char *s;
register size_t size_s;
_CONST char *reject;
size_t size_reject;
{
  register _CONST char *scan;
  register _CONST char *rscan;
  register size_t s_i, r_i;

  for (scan = s, s_i= 0; s_i<size_s; scan++, s_i++) {
	for (rscan = reject, r_i= size_reject; r_i; r_i--)
						/* ++ moved down. */
		if (*scan == *rscan++) return(s_i);
  }
  return(s_i);
}

/*
 * $PchId: memcspn.c,v 1.3 1996/02/22 09:15:56 philip Exp $
 */
