!	i486_alignment_check() - enable/disable alignment check
!							Author: Kees J. Bot
!								23 Nov 1995
! Some programmers know that their programs are running on a
! 386.  On a 386 you can use unaligned memory references, so naturally
! they use them.  The maniac named above has turned on alignment checking
! for the 486.  Here is how it can be turned off (or back on).

.sect .text
.define _i486_alignment_check
_i486_alignment_check:
	pushf				! Current flags
	movb	al, 2(esp)		! Save current AF
	andb	2(esp), ~0x04		! Turn AF off
	cmp	8(esp), 0		! Or should it be on?
	jz	0f
	orb	2(esp), 0x04		! Turn AF on
0:	popf				! Load new flags
	shl	eax, 31-2		! Shift AF to bit 31
	rol	eax, 1			! Rotate AF bit to bit 0 and return
	ret
