/*
nbio_int.h

Created:	12 April 1994 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef NBIO_INT_H
#define NBIO_INT_H

#define _MINIX_SOURCE

#include <sys/nbio.h>
#include <sys/types.h>
#include <assert.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#define SET_SIZE	64	/* deal with at most SET_SIZE fds */

extern fd_set_t nbio_read_all;
extern fd_set_t nbio_write_all;
extern fd_set_t nbio_except_all;

extern fd_set_t nbio_read_block;
extern fd_set_t nbio_write_block;
extern fd_set_t nbio_except_block;

extern asio_fd_set_t nbio_asio_fd_set;

extern struct ip_table
{
	int bl_read;
	int bl_write;
	int bl_except;
	nbio_cb_func_t func;
	nbio_ref_t ref;

	/* For nbio_{read,write} */
	char *buf;
	size_t bufsize;
	size_t data_offset;
	size_t data_size;
	int inprogress;
	int err;
} nbio_ip_table[SET_SIZE][ASIO_NR];

#define READ_BUFSIZE	1024
#define WRITE_BUFSIZE	1024

#ifdef DEBUG_LEVEL
#include <stdio.h>
#define DPRINT(x,y) if ((x) <= DEBUG_LEVEL) \
	{ int s_errno= errno; fprintf y; fflush(stderr); \
	errno= s_errno; } else ((void)0)
#else
#define DPRINT(x,y) ((void) 0)
#endif /* DEBUG_LEVEL */

#endif /* NBIO_INT_H */

/*
 * $PchId: nbio_int.h,v 1.4 1996/02/23 07:14:30 philip Exp $
 */
