/*	asyn_synch() - step back to synch		Author: Kees J. Bot
 *								4 Jun 1994
 */
#include "asyn.h"

int asyn_synch(asynchio_t *asyn, int fd)
/* No more asynchronous operations on this file descriptor. */
{
	asynfd_t *afd;
	int flags;
	int op;

	if ((unsigned) fd >= ASIO_FD_SETSIZE) { errno= EBADF; return -1; }
	afd= &asyn->asyn_afd[fd];

	for (op= 0; op < ASIO_NR; op++) {
		if (afd->afd_op[op].aop_state != IDLE) {
			errno= EAGAIN;
			return -1;
		}
	}

	if ((flags= fcntl(fd, F_GETFD)) < 0) return -1;
	if (fcntl(fd, F_SETFD, flags & ~FD_ASYNCHIO) < 0) return -1;
	afd->afd_seen= 0;
	return 0;
}

/*
 * $PchId: asyn_synch.c,v 1.4 1996/02/22 20:47:38 philip Exp $
 */
