/*	asyn_cancel() - cancel an asynch operation	Author: Kees J. Bot
 *								12 Jul 1996
 */
#include "asyn.h"

int asyn_cancel(asynchio_t *asyn, int fd, int op)
/* Cancel an asynchronous operation if one is in progress. */
{
	asynfd_t *afd;
	asynop_t *aop;
	fwait_t fw;

	if ((unsigned) fd >= ASIO_FD_SETSIZE) { errno= EBADF; return -1; }
	afd= &asyn->asyn_afd[fd];

	aop= &afd->afd_op[op];
	if (aop->aop_state == INPROGRESS) {
		if (fcancel(fd, op) < 0) return -1;
		aop->aop_state= IDLE;

		/* Gather any results, the cancel may be too late. */
		fw.fw_flags= FWF_NONBLOCK;
		fw.fw_bits= asyn->asyn_ports.afds_bits;
		fw.fw_maxfd= ASIO_FD_SETSIZE;

		while (fwait(&fw) != 0) {
			aop= &asyn->asyn_afd[fw.fw_fd].afd_op[fw.fw_operation];
			aop->aop_state= RESULT;
			aop->aop_result= fw.fw_result;
			aop->aop_errno= fw.fw_errno;

			if (!(fw.fw_flags & FWF_MORE)) break;
		}
	}
	return 0;
}
