#!/bin/sh
#
# This script tries to generate a file "iobpeek.h" which defines one
# macro, IOB_MAYBE_EMPTY_P.  The macro can be called with one
# argument, a stdio input stream, and must return a non-zero value if
# the stream's buffer is empty.  If there are characters in the input
# buffer, it *should* return zero.

# work around brain-damaged Ultrix shell
if test -z "$foo" -a -r /bin/sh5
then
  export foo; foo=bar; exec /bin/sh5 $0
fi

CC=$1; test $# != 0 && shift
CFLAGS=$2; test $# != 0 && shift

rm -f ,testfile

echo foo bar > ,testfile

try ()
{
rm -f ,iobtest.c
cat > ,iobtest.c <<EOM
#include <stdio.h>

main (argc, argv) int argc; char **argv;
{
  FILE * in = fopen(",testfile", "r");
  int c;
  if (! in) { fprintf (stderr, "Couldn't open test file\n"); exit (1); }
  if (in->$iob_cnt != 0) {
    fprintf (stderr, "$iob_cnt: %ld\n", (long) in->$iob_cnt); exit (1);
  }
  if (in->$iob_cnt > 0 && (!in->$iob_ptr || (int)*in->$iob_ptr != 'f')) {
    fprintf (stderr, "Buffer seems to be filled, but incorrectly\n");
    exit (1);
  }
  c = getc(in);
  if (c != 'f') { fprintf (stderr, "Read error\n"); exit (1); }
  if (in->$iob_cnt == 0) {
    fprintf (stderr, "$iob_cnt: %ld\n", (long) in->$iob_cnt); exit (1);
  }
  return 0;
}
EOM

$CC $CFLAGS -o ,iobtest ,iobtest.c >/dev/null 2>&1 || return 1
if ./,iobtest > /dev/null
then
  found_iob_ptr=$iob_ptr
  found_iob_cnt=$iob_cnt
  cat > iobpeek.h <<EOM
/* iobpeek.h - DO NOT EDIT!
   Automatically generated by geniobpeek.sh */
#define IOB_MAYBE_EMPTY_P(stream) ((stream)->$iob_cnt <= 0)
EOM
  status=0
else
  status=1
fi
rm ,iobtest ,iobtest.c ,testfile
return $status
}

iob_ptr=_ptr iob_cnt=_cnt; try && exit 0
iob_ptr=ptr  iob_cnt=cnt;  try && exit 0
iob_ptr=_p iob_cnt=_r; try && exit 0		# BSD stdio.h
iob_ptr=_ptr iob_cnt=_count; try && exit 0	# ACK stdio.h

cat 1>&2 <<EOM
*** Error: could not find out how to check for an empty stdio stream
***        buffer on this system.  Please notify Simon Leinen
***        <simon@lia.di.epfl.ch> of this problem.
EOM
exit 1
