:
#!/bin/sh
# @(#)conf/lib/instm.sh	1.7 7/11/92 12:09:36
# Install a set of files into a directory
#
# usage: sh instm.sh [-srk] [-u user] [-g group] [-m mode] dir file...
#
#    Copyright (C) 1987, 1988 Ronald S. Karr and Landon Curt Noll
#    Copyright (C) 1992  Ronald S. Karr
# 
# See the file COPYING, distributed with smail, for restriction
# and warranty information.

# Don't use getopt(1), as we can't rely on it being built yet, or
# existing on the system.

# NOTE: chopped to pieces for Minix by kjb.

usage="Usage: instm.sh [-srk] [-u user] [-g group] [-m mode] dir file..."
user=
group=
mode=
err=0
strip=
rm_old=
dbg=
keep_orig=
link=true

# put /etc in path, for chmod
PATH="$PATH:/etc"

# Note:  this shell script uses case rather than test, where possible
#	 to prevent a fork/exec on systems where test is not a builtin.

# process the list of options.
# Note:  the option letters and option arguments must be separate tokens.
while : ; do
	case $# in
	0)	break;
	esac
	case "$1" in
	--)	shift; break;;
	-[ugm])case $# in
		1)	err=1;;
		esac
		case "$1" in
		-u)	user="$2"; link=;;
		-g)	group="$2"; link=;;
		-m)	mode="$2"; link=;;
		esac
		shift; shift;;
	-s)	strip=true; shift;;
	-r)	rm_old=true; shift;;
	-k)	keep_orig=true; shift;;
	-D)	dbg=echo; shift;;
	-*)	err=1; break;;
	*)	break;
	esac
done

# There must be at least two operands
case $# in
0|1)	err=1;;
esac

# If an error occured, spit out a usage message.
case "$err" in
1)	echo "$usage" 1>&2
	exit 1;;
esac

# the directory name is the first operand
dir="$1"; shift

for file in "$@"; do
	dst="$dir/$file"
	if $dbg install -c${strip:+s}${link:+l} ${user:+-o} $user \
		${group:+-g} $group ${mode:+-m} $mode "$file" "$dst"
	then
		:
	else
		$dbg rm -f "$old"
		echo "instm: failed to install $file as $dst" >&2
		err=1
		continue
	fi
done

exit $err
