/*
bsd44/lib/libc/minix/writev.c

Created:	April 1995 by Philip Homburg <philip@cs.vu.nl>
*/

#include <minix/stubs.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <string.h>
#include <unistd.h>

ssize_t __bsd_writev(fd, iov, iovcnt)
int fd;
const struct iovec *iov;
int iovcnt;
{
	char buf[1024];
	size_t iov_len;
	ssize_t r, siz;
	int i;

	/* The BSD writev implementation is atomic. For Minix this would
	 * require an extra copy of all the data. To prevent this
	 * performance loss, we only copy small amounts of data.
	 */
	siz= 0;
	for (i= 0; i<iovcnt; i++)
		siz += iov[i].iov_len;
	if (siz <= sizeof(buf))
	{
		siz= 0;
		for (i= 0; i<iovcnt; i++)
		{
			iov_len= iov[i].iov_len;
			memcpy(buf+siz, iov[i].iov_base, iov_len);
			siz += iov_len;
		}
		return write(fd, buf, siz);
	}
	siz= 0;
	for (i= 0; i<iovcnt; i++)
	{
		iov_len= iov[i].iov_len;
		r= write(fd, iov[i].iov_base, iov_len);
		if (r > 0)
			siz += r;
		if (r == iov_len)
			continue;
		if (siz == 0 && r == -1)
			siz= -1;
		break;
	}
	return siz;
}

/*
 * $PchId: writev.c,v 1.1 1995/11/20 19:48:08 philip Exp $
 */
