/*
 * Copyright (c) 1983 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)tip.h	5.7 (Berkeley) 3/27/91
 */

/*
 * tip - terminal interface program
 */

#include <sys/types.h>
#ifndef _MINIX
#include <machine/endian.h>
#include <sys/file.h>
#include <sys/time.h>
#endif

#ifndef _MINIX
#include <sgtty.h>
#else
#include <termios.h>
#endif
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <ctype.h>
#include <setjmp.h>
#include <unistd.h>
#include <errno.h>

#ifdef _MINIX
#include <minix/cfg_public.h>
#endif

#include "ansi.h"

/*
 * Remote host attributes
 */
char	*DV;			/* UNIX device(s) to open */
char	*EL;			/* chars marking an EOL */
char	*CM;			/* initial connection message */
char	*IE;			/* EOT to expect on input */
char	*OE;			/* EOT to send to complete FT */
char	*CU;			/* call unit if making a phone call */
char	*AT;			/* acu type */
char	*PN;			/* phone number(s) */
char	*DI;			/* disconnect string */
char	*PA;			/* parity to be generated */

char	*PH;			/* phone number file */
char	*RM;			/* remote file name */
char	*HO;			/* host name */

int	BR;			/* line speed for conversation */
int	FS;			/* frame size for transfers */

char	DU;			/* this host is dialed up */
char	HW;			/* this device is hardwired, see hunt.c */
char	*ES;			/* escape character */
char	*EX;			/* exceptions */
char	*FO;			/* force (literal next) char*/
char	*RC;			/* raise character */
char	*RE;			/* script record file */
char	*PR;			/* remote prompt */
int	DL;			/* line delay for file transfers to remote */
int	CL;			/* char delay for file transfers to remote */
int	ET;			/* echocheck timeout */
char	HD;			/* this host is half duplex - do local echo */

/*
 * String value table
 */
typedef
	struct {
		char	*v_name;	/* whose name is it */
		char	v_type;		/* for interpreting set's */
		char	v_access;	/* protection of touchy ones */
		char	*v_abrev;	/* possible abreviation */
		char	*v_value;	/* casted to a union later */
	}
	value_t;

#define STRING	01		/* string valued */
#define BOOL	02		/* true-false value */
#define NUMBER	04		/* numeric value */
#define CHAR	010		/* character value */

#define WRITE	01		/* write access to variable */
#define	READ	02		/* read access */

#define CHANGED	01		/* low bit is used to show modification */
#define PUBLIC	1		/* public access rights */
#define PRIVATE	03		/* private to definer */
#define ROOT	05		/* root defined */

#define	TRUE	1
#define FALSE	0

#define ENVIRON	020		/* initialize out of the environment */
#define IREMOTE	040		/* initialize out of remote structure */
#define INIT	0100		/* static data space used for initialization */
#define TMASK	017

/*
 * Definition of ACU line description
 */
typedef
	struct {
		char	*acu_name;
		int	(*acu_dialer) ARGS(( char *num, char *mod ));
		void	(*acu_disconnect) ARGS(( void ));
		void	(*acu_abort) ARGS(( void ));
	}
	acu_t;

#define	equal(a, b)	(strcmp(a,b)==0)/* A nice function to string compare */

/*
 * variable manipulation stuff --
 *   if we defined the value entry in value_t, then we couldn't
 *   initialize it in vars.c, so we cast it as needed to keep lint
 *   happy.
 */
typedef
	union {
		int	zz_number;
		short	zz_boolean[2];
		char	zz_character[4];
		int	*zz_address;
	}
	zzhack;

#define value(v)	vtable[v].v_value

#define number(v)	((((zzhack *)(&(v))))->zz_number)

#ifndef _MINIX

#if BYTE_ORDER == LITTLE_ENDIAN
#define boolean(v)	((((zzhack *)(&(v))))->zz_boolean[0])
#define character(v)	((((zzhack *)(&(v))))->zz_character[0])
#endif

#if BYTE_ORDER == BIG_ENDIAN
#define boolean(v)	((((zzhack *)(&(v))))->zz_boolean[1])
#define character(v)	((((zzhack *)(&(v))))->zz_character[3])
#endif

#else /* _MINIX */

#if _BYTEORDER_16 == 0x0102                     /* Big endian */
#define boolean(v)	((((zzhack *)(&(v))))->zz_boolean[1])
#define character(v)	((((zzhack *)(&(v))))->zz_character[3])
#endif

#if _BYTEORDER_16 == 0x0201                     /* Little endian */
#define boolean(v)	((((zzhack *)(&(v))))->zz_boolean[0])
#define character(v)	((((zzhack *)(&(v))))->zz_character[0])
#endif

#ifndef boolean
#	error Strange value in _BYTEORDER_16
#endif

#endif /* !_MINIX */

#define address(v)	((((zzhack *)(&(v))))->zz_address)

/*
 * Escape command table definitions --
 *   lookup in this table is performed when ``escapec'' is recognized
 *   at the begining of a line (as defined by the eolmarks variable).
*/

typedef
	struct {
		char	e_char;		/* char to match on */
		char	e_flags;	/* experimental, priviledged */
		char	*e_help;	/* help string */
		void 	(*e_func) ARGS(( char c ));	/* command */
	}
	esctable_t;

#define NORM	00		/* normal protection, execute anyone */
#define EXP	01		/* experimental, mark it with a `*' on help */
#define PRIV	02		/* priviledged, root execute only */

extern int	vflag;		/* verbose during reading of .tiprc file */
extern value_t	vtable[];	/* variable table */

#ifndef ACULOG
#define logent(a, b, c, d)
#define loginit()
#endif

/*
 * Definition of indices into variable table so
 *  value(DEFINE) turns into a static address.
 */

#define BEAUTIFY	0
#define BAUDRATE	1
#define DIALTIMEOUT	2
#define EOFREAD		3
#define EOFWRITE	4
#define EOL		5
#define ESCAPE		6
#define EXCEPTIONS	7
#define FORCE		8
#define FRAMESIZE	9
#define HOST		10
#define LOG		11
#define PHONES		12
#define PROMPT		13
#define RAISE		14
#define RAISECHAR	15
#define RECORD		16
#define REMOTE		17
#define SCRIPT		18
#define TABEXPAND	19
#define VERBOSE		20
#define SHELL		21
#define HOME		22
#define ECHOCHECK	23
#define DISCONNECT	24
#define TAND		25
#define LDELAY		26
#define CDELAY		27
#define ETIMEOUT	28
#define RAWFTP		29
#define HALFDUPLEX	30
#define	LECHO		31
#define	PARITY		32

#define NOVAL	((value_t *)NULL)
#define NOACU	((acu_t *)NULL)
#define NOSTR	((char *)NULL)
#define NOFILE	((FILE *)NULL)
#define NOPWD	((struct passwd *)0)

#ifndef _MINIX
struct sgttyb	arg;		/* current mode of local terminal */
struct sgttyb	defarg;		/* initial mode of local terminal */
struct tchars	tchars;		/* current state of terminal */
struct tchars	defchars;	/* initial state of terminal */
struct ltchars	ltchars;	/* current local characters of terminal */
struct ltchars	deflchars;	/* initial local characters of terminal */
#else /* _MINIX */
struct termios	arg;		/* current state of local terminal */
struct termios	defarg;		/* initial state of local terminal */
#endif

FILE	*fscript;		/* FILE for scripting */

int	fildes[2];		/* file transfer synchronization channel */
int	repdes[2];		/* read process sychronization channel */
int	FD;			/* open file descriptor to remote host */
int	AC;			/* open file descriptor to dialer (v831 only) */
int	vflag;			/* print .tiprc initialization sequence */
int	sfd;			/* for ~< operation */
int	pid;			/* pid of tipout */
uid_t	uid, euid;		/* real and effective user id's */
gid_t	gid, egid;		/* real and effective group id's */
int	stop;			/* stop transfer session flag */
int	quit;			/* same; but on other end */
int	intflag;		/* recognized interrupt */
int	stoprompt;		/* for interrupting a prompt session */
int	timedout;		/* ~> transfer timedout */
int	cumode;			/* simulating the "cu" program */

char	fname[80];		/* file name buffer for ~< */
char	copyname[80];		/* file name buffer for ~> */
char	ccc;			/* synchronization character */
char	ch;			/* for tipout */
char	*uucplock;		/* name of lock file for uucp's */

#ifndef _MINIX
int	odisc;				/* initial tty line discipline */
extern	int disc;			/* current tty discpline */
#endif

/* forward structs */
struct baud;

/* cu.c */

void cumain ARGS(( int argc, char *argv[] ));

/* tip.c */

void cleanup ARGS(( int sig ));
struct baud *speed ARGS(( int n ));
void user_uid ARGS(( void ));
void daemon_uid ARGS(( void ));
void setparity ARGS(( char *defparity ));
void ttysetup ARGS(( struct baud *speed ));
int prompt ARGS(( char *s, char *p ));
void pwrite ARGS(( int fd, char *buf, int n ));
int any ARGS(( char c, char *p ));
char *ctrl ARGS(( char c ));
void unraw ARGS(( void ));
void raw ARGS(( void ));
void shell_uid ARGS(( void ));
char *interp ARGS(( char *s ));
void help ARGS(( char c ));
int size ARGS(( char *s ));
char escape ARGS(( void ));

/* uucplock.c */

int uu_lock ARGS(( char *ttyname ));
int uu_unlock ARGS(( char *ttyname ));

/* remote.c */

char *getremote ARGS(( char *host ));

/* value.c */

void vinit ARGS(( void ));
int vstring ARGS(( char *s, char *v ));
void vlex ARGS(( char *s ));

/* cmds.c */

char *expand ARGS(( char name[] ));
void getfl ARGS(( char c ));
void cu_take ARGS(( char cc ));
void pipefile ARGS(( char c ));
void sendfile ARGS(( char cc ));
void send ARGS(( char c ));
void cu_put ARGS(( char cc ));
void timeout ARGS(( int sig ));
void pipeout ARGS(( char c ));
void shell ARGS(( char c ));
void setscript ARGS(( void ));
void chdirectory ARGS(( char c ));
void tipabort ARGS(( char *msg ));
void finish ARGS(( char c ));
void variable ARGS(( char c ));
void tandem ARGS(( char *option ));
void suspend ARGS(( char c ));
void genbrk ARGS(( char c ));
void consh ARGS(( char c ));

/* acu.c */

char *connect ARGS(( void ));
void disconnect ARGS(( char *reason ));

/* tipout.c */

void tipout ARGS(( void ));

/* hunt.c */

int hunt ARGS(( char *name ));

