/* The <time.h> header is used by the procedures that deal with time.
 * Handling time is surprisingly complicated, what with GMT, local time
 * and other factors.  Although the Bishop of Ussher (1581-1656) once
 * calculated that based on the Bible, the world began on 12 Oct. 4004 BC
 * at 9 o'clock in the morning, in the UNIX world time begins at midnight, 
 * 1 Jan. 1970 GMT.  Before that, all was NULL and (void).
 */

#ifndef _TIME_H
#define _TIME_H

#if _BSD_ANSI_LIB_SRC
#define _BSD_TIME	1
#endif

#include <minix/ansi.h>
#include <minix/posix.h>
_C_BEGIN

#define CLOCKS_PER_SEC    60	/* MINIX always uses 60 Hz, even in Europe */

#ifdef _POSIX_SOURCE
#define CLK_TCK CLOCKS_PER_SEC	/* obsolescent mame for CLOCKS_PER_SEC */
#endif

#define NULL    ((void *)0)

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;
#endif

#ifndef _TIME_T
#define _TIME_T
typedef long time_t;		/* time in sec since 1 Jan 1970 0000 GMT */
#endif

#ifndef _CLOCK_T
#define _CLOCK_T
typedef long clock_t;		/* time in ticks since process started */
#endif

struct tm {
  int tm_sec;			/* seconds after the minute [0, 59] */
  int tm_min;			/* minutes after the hour [0, 59] */
  int tm_hour;			/* hours since midnight [0, 23] */
  int tm_mday;			/* day of the month [1, 31] */
  int tm_mon;			/* months since January [0, 11] */
  int tm_year;			/* years since 1900 */
  int tm_wday;			/* days since Sunday [0, 6] */
  int tm_yday;			/* days since January 1 [0, 365] */
  int tm_isdst;			/* Daylight Saving Time flag */
#if _BSD_TIME
  long	tm_gmtoff;		/* offset from CUT in seconds */
  char	*tm_zone;		/* timezone abbreviation */
#endif
};

extern char *tzname[];

/* Function Prototypes. */
_PROTOTYPE( clock_t clock, (void)					);
_PROTOTYPE( double difftime, (time_t _time1, time_t _time0)		);
_PROTOTYPE( time_t mktime, (struct tm *_timeptr)			);
_PROTOTYPE( time_t time, (time_t *_timeptr)				);
_PROTOTYPE( char *asctime, (const struct tm *_timeptr)			);
_PROTOTYPE( char *ctime, (const time_t *_timer)			);
_PROTOTYPE( struct tm *gmtime, (const time_t *_timer)			);
_PROTOTYPE( struct tm *localtime, (const time_t *_timer)		);
_PROTOTYPE( size_t strftime, (char *_s, size_t _max, const char *_fmt,
				const struct tm *_timep)		);

#ifdef _POSIX_SOURCE
_PROTOTYPE( void tzset, (void)						);
#endif

#ifdef _MINIX_SOURCE
_PROTOTYPE( int stime, (time_t *_top)					);

struct timeval
{
	long tv_sec;
	long tv_usec;
};

struct timezone
{
	int tz_offset;
	int tz_dst;
};

_PROTOTYPE( int sysutime, (int _op, struct timeval *_tvp)		);

#define UTIME_TIMEOFDAY		0
#define UTIME_BOOTTIME		1
#define UTIME_UPTIME		2
#define UTIME_GETALARM		3
#define UTIME_SETALARM		4

/* The following commands are only available to root. */
#define UTIME_DEFRATE		0x100	/* Default number of cycles per
					 * clock tick.
					 */
#define UTIME_GETRATE		0x101	/* Current number of cycles per
					 * clock tick.
					 */
#define UTIME_SETRATE		0x102	/* Set the number of cycles per
					 * clock tick.
					 */

_PROTOTYPE( void usleep, (unsigned long usecs)				);
_PROTOTYPE( int u_sleep, (struct timeval *tvp)				);
_PROTOTYPE( int gettimeofday, (struct timeval *tp, struct timezone *tzp));

#endif /* _MINIX_SOURCE */

#endif /* _TIME_H */

/*
 * $PchId: time.h,v 1.4 1996/01/19 21:45:39 philip Exp $
 */
