/* <sys/utsname.h> describes the machine and O.S.	Author: Kees J. Bot
 */

#ifndef _SYS__UTSNAME_H
#define _SYS__UTSNAME_H

#include <minix/ansi.h>
#include <minix/posix.h>
#include <minix/types.h>
_C_BEGIN

/* Strings describing the system, always null terminated.  The Minix specific
 * function setuname may be used to change some of the values (most are fixed).
 * EPERM will be returned if you (or even root) try to change values you aren't
 * allowed to.  The POSIX uname() function retrieves the values, but only
 * Minix knows about the last few, so do not reference them in portable
 * programs.  No old programs will break if this struct changes, but please
 * keep the size of the entries at a multiple of 4.
 */

struct utsname {
  char	sysname[15+1];		/* System name:		Minix-vmd	*/
  char	nodename[255+1];	/* Node/Network name:	dinghy.cs.vu.nl */
  char	release[15+1];		/* O.S. release:	1.6.25	*/
  char	version[11+1];		/* O.S. version:	0	*/
  char	machine[11+1];		/* Machine hardware:	i486	*/

  /* Minix additions */
  char	arch[11+1];		/* Architecture:	i386	*/
  char	kernel[11+1];		/* Kernel architecture:	i386	*/
  char	hostname[15+1];		/* Hostname:		dinghy	*/
  char	bus[11+1];		/* Bus architecture:	ibm	*/
};

/* "Machine" shows the kind of CPU used, "arch" tells what kind of binaries
 * run on the system, and "kernel" the kernel type.  The latter could be i486
 * if the kernel could only run on a 486.
 */

#ifdef _MINIX_SOURCE
/* Uname() is implemented with sysuname(). */

_PROTOTYPE( int sysuname, (int _req, int _field, char *_value, 
							_mnx_size_t _len));

/* req: Get or set a string. */
#define _UTS_GET	0
#define _UTS_SET	1

/* field: What field to get or set.  These values can't be changed lightly. */
#define _UTS_ARCH	0
#define _UTS_KERNEL	1
#define _UTS_MACHINE	2
#define _UTS_HOSTNAME	3
#define _UTS_NODENAME	4
#define _UTS_RELEASE	5
#define _UTS_VERSION	6
#define _UTS_SYSNAME	7
#define _UTS_BUS	8
#define _UTS_MAX	9	/* Number of strings. */
#endif /* _MINIX_SOURCE */

_PROTOTYPE( int uname, (struct utsname *_name)				);

_C_END
#endif /* _SYS__UTSNAME_H */

/*
 * $PchId: utsname.h,v 1.5 1995/11/17 22:01:23 philip Exp $
 */
