#ifndef _SYS__SIGCONTEXT_H
#define _SYS__SIGCONTEXT_H

/* The sigcontext structure is used by the sigreturn(2) system call.
 * sigreturn() is seldom called by user programs, but it is used internally
 * by the signal catching mechanism.
 */

#include <minix/ansi.h>
#include <minix/cfg_lib.h>
#include <minix/types.h>

/* The following structure should match the stackframe_s structure used
 * by the kernel's context switching code.  Floating point registers should
 * be added in a different struct.
 */
#if _INTEL_CPU
struct sigregs {  
#if _WORD_SIZE == 4
  short sr_gs;
  short sr_fs;
#endif
  short sr_ss;
  short sr_cs;
  short sr_es;
  short sr_ds;
  int sr_di;
  int sr_si;
  int sr_bp;
  int sr_sp;
  int sr_bx;
  int sr_dx;
  int sr_cx;
  int sr_ax;
  int sr_pc;
  int sr_flags;
};

struct fpregs {
  _mnx_u16_t fpr_cw;		/* x87/486 control word */
  _mnx_u16_t fpr_res0;		/* intel reserved */
  _mnx_u16_t fpr_sw;		/* x87/486 status word */
  _mnx_u16_t fpr_res1;		/* intel reserved */
  _mnx_u16_t fpr_tw;		/* x87/486 tag word */
  _mnx_u16_t fpr_res2;		/* intel reserved */
  _mnx_u32_t fpr_ip;		/* x87/486 ip of last fp instruction */
  _mnx_u16_t fpr_cs;		/* selector of fpr_ip */
  _mnx_u16_t fpr_res3;		/* intel reserved */
  _mnx_u32_t fpr_dp;		/* x87/486 op ptr of last fp instruction */
  _mnx_u16_t fpr_ds;		/* selector of fpr_dp */
  _mnx_u16_t fpr_res4;		/* intel reserved */
  unsigned char fpr_reg[8][10];	/* 8 10-byte fp registers */
};

#define _SIGREGS
#endif /* _INTEL_CPU */

#if _M68000_CPU
struct sigregs {  
  long sr_retreg;			/* d0 */
  long sr_d1;
  long sr_d2;
  long sr_d3;
  long sr_d4;
  long sr_d5;
  long sr_d6;
  long sr_d7;
  long sr_a0;
  long sr_a1;
  long sr_a2;
  long sr_a3;
  long sr_a4;
  long sr_a5;
  long sr_a6;
  long sr_sp;			/* also known as a7 */
  long sr_pc;
  short sr_psw;
  short sr_dummy;		/* make size multiple of 4 for system.c */
};
#define _SIGREGS
#endif /* _M68000_CPU */

#ifndef _SIGREGS
# error		error, processor is not supported
#endif /* !_SIGREGS */
#undef _SIGREGS

struct sigcontext {
  _mnx_size_t sc_size;		/* complete size of the context */
  int sc_version;		/* which version */
  int sc_flags;			/* sigstack state to restore */
  long sc_mask;			/* signal mask to restore */
  struct sigregs sc_regs;	/* register set to restore */
  struct fpregs sc_fpregs;	/* floating point context */
};

#define SC_VERSION	1	/* this is the first version */

#if _INTEL_CPU
#define sr_retreg sr_ax
#define sr_fp sr_bp
#define sr_psw sr_flags

struct sigframe {		/* stack frame created for signalled process */
  _PROTOTYPE( void (*sf_retadr), (void) );
  int sf_signo;
  int sf_code;
  struct sigcontext *sf_scp;
  int sf_bp;
  _PROTOTYPE( void (*sf_retadr2), (void) );
  struct sigcontext *sf_scpcopy;
  struct sigcontext sf_sc;
};
#endif /* _INTEL_CPU */

#if _M68000_CPU
#define sc_retreg sc_regs.sr_retreg
#define sc_d1 sc_regs.sr_d1
#define sc_d2 sc_regs.sr_d2
#define sc_d3 sc_regs.sr_d3
#define sc_d4 sc_regs.sr_d4
#define sc_d5 sc_regs.sr_d5
#define sc_d6 sc_regs.sr_d6
#define sc_d7 sc_regs.sr_d7
#define sc_a0 sc_regs.sr_a0
#define sc_a1 sc_regs.sr_a1
#define sc_a2 sc_regs.sr_a2
#define sc_a3 sc_regs.sr_a3
#define sc_a4 sc_regs.sr_a4
#define sc_a5 sc_regs.sr_a5
#define sc_fp sc_regs.sr_a6
#define sc_sp sc_regs.sr_sp
#define sc_pc sc_regs.sr_pc
#define sc_psw sc_regs.sr_psw
#endif /* _M68000_CPU */

/* Values for sc_flags.  Must agree with <minix/jmp_buf.h>. */
#define SC_SIGCONTEXT	 0x2	/* nonzero when signal context is included */
#define SC_NOREGLOCALS	 0x4	/* nonzero when registers are not to be
				 * saved and restored
				 */

/* If SC_FPU_RESTORE is set, the fpu context will be restored by sigreturn.
 * If SC_FPU_INIT is also set, the fpu context will be initialized, otherwise,
 * it will be taken from the signal context. In that case, SC_FPU_CONTEXT
 * should also be set, and SC_FPU_INVALID determines whether the context will 
 * be marked as invalid or not.
 */
#define SC_FPU_RESTORE	 0x8
#define SC_FPU_INIT	0x10
#define SC_FPU_CONTEXT	0x20	/* set when an fpu context in present */
#define SC_FPU_INVALID	0x40	/* set when the fpu context caused an 
				 * exception, to be use in combination with
				 * SC_FPU_CONTEXT
				 */

_PROTOTYPE( int sigreturn, (struct sigcontext *_scp)			);

#endif /* _SYS__SIGCONTEXT_H */

/*
 * $PchId: sigcontext.h,v 1.4 1995/11/17 21:50:09 philip Exp $
 */
