/* <sys/mount.h> describes the flags and return value of the new mount(2)
 * call.						Author: Kees J. Bot
 */
#ifndef _SYS__MOUNT_H
#define _SYS__MOUNT_H

/* Mount type flags: */
#define M_RDONLY	0x0001	/* Read only */
#define M_NOSUID	0x0002	/* Set-uid execution inhibited */
#define M_REMOUNT	0x0004	/* Remount with new options */
#define M_GRPID		0x0008	/* Inherit group id from directory */
#define M_NF		0x0010	/* Use next-fit block/inode allocation */
#define M_FLAGS		0x00FF	/* Select mount flags */

/* Device type flags: */
#define M_DEV		0x0100	/* Mount a block device of unknown type */
#define M_V1		0x0200	/* Version 1 FS */
#define M_V2		0x0300	/* Version 2 FS */
#define M_V1F		0x0400	/* V1 FS, flex dirs */
#define M_V2F		0x0500	/* V2 FS, flex dirs */
#define M_LO		0x0600	/* Loopback */
#define M_TYPE		0xFF00	/* Select device type */

/* The return value of the new style mount echos the flags, but with M_DEV
 * changed to the proper device type.  If no device type is given then M_DEV
 * is assumed, but the return value will be 0 (old mount).
 */
#endif /* _SYS__MOUNT_H */

/*
 * $PchId: mount.h,v 1.5 1995/11/17 21:52:24 philip Exp $
 */
