/* <sys/mnttab.h> is used by getmntent(3).		Author: Kees J. Bot
 */
#ifndef _SYS__MNTTAB_H
#define _SYS__MNTTAB_H

#include <minix/ansi.h>
_C_BEGIN

struct mnttab {
	char	*mnt_special;	/* name of mounted device */
	char	*mnt_mountp;	/* mount point */
	char	*mnt_fstype;	/* type of mount: dev, swap, 1, 2f ... */
	char	*mnt_mntopts;	/* options: ro, rw, noauto, ... */
	char	*mnt_freq;	/* how often to dump (days) */
	char	*mnt_fsckpass;	/* fsck pass number */
	char	*mnt_time;	/* time of mount as by time(2) */
};

_PROTOTYPE( int getmntent, (FILE *_mfp, struct mnttab *_mtp)		);
_PROTOTYPE( int getmntany, (FILE *_mfp, struct mnttab *_mtp, 
					const struct mnttab *_look)	);
_PROTOTYPE( char *hasmntopt, (struct mnttab *_mtp, const char *_opt)	);
_PROTOTYPE( int putmntent, (FILE *_mfp, const struct mnttab *_mtp)	);

#define MNT_LINE_MAX	256	/* Internal buffer for one line. */
#define MNT_TOOLONG	1	/* Line in mtab is too long. */
#define MNT_TOOMANY	2	/* Too many fields. */
#define MNT_TOOFEW	3	/* Too few fields. */

_C_END
#endif /* _SYS__MNTTAB_H */

/*
 * $PchId: mnttab.h,v 1.3 1995/11/17 21:53:20 philip Exp $
 */
