/*
sys/kbdio.h

Define structures and constants for keyboard ioctls.

Created:	Dec 31, 1992 by Philip Homburg
*/

#ifndef _SYS__KBDIO_H
#define _SYS__KBDIO_H

typedef struct kio_bell
{
	unsigned kb_pitch;		/* Bell frequency in HZ */
	unsigned long kb_volume;	/* Volume in micro volts */
	struct timeval kb_duration;
} kio_bell_t;

typedef struct kio_leds
{
	unsigned kl_bits;
} kio_leds_t;

#define KBD_LEDS_NUM	0x1
#define KBD_LEDS_CAPS	0x2
#define KBD_LEDS_SCROLL	0x4

typedef struct kio_map
{
	size_t km_entries;
	struct keymap *km_keymap;
	size_t km_strsize;
	char *km_strtab;
} kio_map_t;

#endif /* _SYS__KBDIO_H */

/*
 * $PchId: kbdio.h,v 1.4 1996/03/12 18:54:51 philip Exp $
 */
