/*	asynchio.h - Asynchronous I/O			Author: Kees J. Bot
 *								4 Jun 1994
 */
#ifndef _SYS__ASYNCHIO_H
#define _SYS__ASYNCHIO_H

struct _asynop {
	int		aop_state;	/* Operation state. */
	int		aop_result;	/* Results of an operation. */
	int		aop_errno;
};

struct _asynfd {
	int		afd_seen;	/* Filedescriptor is asynchronous. */
	struct _asynop	afd_op[ASIO_NR];
};

typedef struct {
	int		asyn_more;	/* Set if more to do before blocking. */
	struct _asynfd	asyn_afd[ASIO_FD_SETSIZE];
	asio_fd_set_t	asyn_ports;	/* Fwait() operation bits. */
} asynchio_t;

#define ASYN_NONBLOCK	0x01		/* If asyn_wait() mustn't block. */

struct timeval;

void asyn_init(asynchio_t *_asyn);
ssize_t asyn_read(asynchio_t *_asyn, int _fd, void *_buf, size_t _len);
ssize_t asyn_write(asynchio_t *_asyn, int _fd, const void *_buf, size_t _len);
int asyn_ioctl(asynchio_t *_asyn, int _fd, _mnx_ioreq_t _request, void *_data);
int asyn_wait(asynchio_t *_asyn, int _flags, struct timeval *to);
int asyn_cancel(asynchio_t *_asyn, int _fd, int _op);
int asyn_pending(asynchio_t *_asyn, int _fd, int _op);
int asyn_synch(asynchio_t *_asyn, int _fd);
int asyn_close(asynchio_t *_asyn, int _fd);

#endif /* _SYS__ASYNCHIO_H */

/* $PchId: asynchio.h,v 1.3 1995/11/17 21:57:48 philip Exp $ */
