/* The <stddef.h> header defines certain commonly used macros. */

#ifndef _STDDEF_H
#define _STDDEF_H

#define NULL   ((void *)0)

/* The following is not portable, but the compiler accepts it. */
#define offsetof(type, ident)	((size_t) (unsigned long) &((type *)0)->ident)

#if _PTR_SIZE == _WORD_SIZE
typedef int ptrdiff_t;		/* result of subtracting two pointers */
#else
typedef long ptrdiff_t;
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;	/* type returned by sizeof */
#endif

#ifndef _WCHAR_T
#define _WCHAR_T
typedef int wchar_t;		/* type expanded character set */
#endif

#endif /* _STDDEF_H */

/*
 * $PchId: stddef.h,v 1.4 1995/11/17 22:08:06 philip Exp $
 */
