/* The <pwd.h> header defines the items in the password file. */

#ifndef _PWD_H
#define _PWD_H

#include <minix/ansi.h>
#include <minix/posix.h>
#include <minix/types.h>
_C_BEGIN

struct passwd {
  char *pw_name;		/* login name */
  _mnx_uid_t pw_uid;		/* uid corresponding to the name */
  _mnx_gid_t pw_gid;		/* gid corresponding to the name */
  char *pw_dir;			/* user's home directory */
  char *pw_shell;		/* name of the user's shell */

  /* The following members are not defined by POSIX. */
  char *pw_passwd;		/* password information */
  char *pw_gecos;		/* just in case you have a GE 645 around */
};


/* Function Prototypes. */
_PROTOTYPE( struct passwd *getpwnam, (const char *_name)		);
_PROTOTYPE( struct passwd *getpwuid, (_mnx_Uid_t _uid)			);

#ifdef _MINIX_SOURCE
_PROTOTYPE( void endpwent, (void)					);
_PROTOTYPE( struct passwd *getpwent, (void)				);
_PROTOTYPE( int setpwent, (void)					);
_PROTOTYPE( void setpwfile, (const char *_file)				);
#endif

_C_END
#endif /* _PWD_H */

/*
 * $PchId: pwd.h,v 1.3 1995/11/17 22:12:38 philip Exp $
 */
