/*
The following macro definitions convert to and from the network standard byte
order. The macros with their name in lower case guarantee to evaluate their
argument exectly once. The function of the macros is encoded in their names;
htons means convert a (unsigned) short in host byte order to network byte order.
*/

#ifndef _NET__HTON_H
#define _NET__HTON_H

#include <minix/cfg_lib.h>

extern u16_t _tmp;
extern u32_t _tmp_l;

#if _BYTEORDER_16 == 0x0102			/* Big endian */
#define htons(x) (x)
#define HTONS(x) (x)
#define ntohs(x) (x)
#define NTOHS(x) (x)
#endif /* _BYTEORDER_16 == 0x0102 */

#if _BYTEORDER_16 == 0x0201			/* Little endian */
#define htons(x) (_tmp=(x), ((_tmp>>8) & 0xff) | ((_tmp<<8) & 0xff00))
#define HTONS(x) ( ( (((unsigned short)(x)) >>8) & 0xff) | \
		((((unsigned short)(x)) & 0xff)<<8) )

#define ntohs(x) (_tmp=(x), ((_tmp>>8) & 0xff) | ((_tmp<<8) & 0xff00))
#define NTOHS(x) ( ( (((unsigned short)(x)) >>8) & 0xff) | \
		((((unsigned short)(x)) & 0xff)<<8) )
#endif /* _BYTEORDER_16 == 0x0201 */

#ifndef htons
# error		strange value in _BYTEORDER_16
#endif

#if _BYTEORDER_32 == 0x01020304			/* Big endian */
#define htonl(x) (x)
#define HTONL(x) (x)
#define ntohl(x) (x)
#define NTOHL(x) (x)
#endif /* _BYTEORDER_32 == 0x01020304 */

#if _BYTEORDER_32 == 0x04030201			/* Little endian */
#define htonl(x) (_tmp_l=(x), ((_tmp_l>>24) & 0xffL) | \
	((_tmp_l>>8) & 0xff00L) | \
	((_tmp_l<<8) & 0xff0000L) | ((_tmp_l<<24) & 0xff000000L))
#define HTONL(x) ((((x)>>24) & 0xffL) | (((x)>>8) & 0xff00L) | \
	(((x)<<8) & 0xff0000L) | (((x)<<24) & 0xff000000L))
#define ntohl(x) (_tmp_l=(x), ((_tmp_l>>24) & 0xffL) \
	| ((_tmp_l>>8) & 0xff00L) | \
	((_tmp_l<<8) & 0xff0000L) | ((_tmp_l<<24) & 0xff000000L))
#define NTOHL(x) ((((x)>>24) & 0xffL) | (((x)>>8) & 0xff00L) | \
	(((x)<<8) & 0xff0000L) | (((x)<<24) & 0xff000000L))
#endif /* _BYTEORDER_32 == 0x04030201 */

#ifndef htonl
# error		strange value in _BYTEORDER_32
#endif

#endif /* _NET__HTON_H */

/*
 * $PchId: hton.h,v 1.3 1995/11/17 22:14:25 philip Exp $
 */
