/* The <minix/types.h> header contains minix versions of important data type 
 * definitions. These defininions are prefixed with _mnx_ to avoid name
 * space space problems.
 */

#ifndef _MINIX__TYPES_H
#define _MINIX__TYPES_H

#include <minix/ansi.h>
#include <minix/cfg_lib.h>

/* The type size_t holds all results of the sizeof operator.  At first glance,
 * it seems obvious that it should be an unsigned int, but this is not always 
 * the case. For example, MINIX-ST (68000) has 32-bit pointers and 16-bit
 * integers. When one asks for the size of a 70K struct or array, the result 
 * requires 17 bits to express, so size_t must be a long type.  The type 
 * ssize_t is the signed version of size_t.
 */
typedef unsigned int _mnx_size_t;

typedef int _mnx_ssize_t;

typedef long _mnx_time_t;	   /* time in sec since 1 Jan 1970 0000 GMT */

typedef long _mnx_clock_t;	   /* unit for system accounting */

typedef unsigned long _mnx_sigset_t;

/* Signal handler type, e.g. SIG_IGN */
typedef void (*_mnx_sighandler_t) _ARGS(( int ));

/* Types used in disk, inode, etc. data structures. */
typedef short		_mnx_dev_t;	/* holds (major|minor) device pair */
typedef short		_mnx_gid_t;	/* group id */
typedef unsigned short	_mnx_ino_t; 	/* i-node number */

typedef unsigned short	_mnx_mode_t;	/* file type and permissions bits */
typedef unsigned short	_mnx_nlink_t;	/* number of links to a file */
typedef long		_mnx_off_t;	/* offset within a file */
typedef int		_mnx_pid_t;	/* process id (must be signed) */
typedef short		_mnx_uid_t;	/* user id */
typedef unsigned long	_mnx_block_t;	/* block number */
typedef unsigned long	_mnx_bit_t;	/* bit number in a bit map */
typedef unsigned short	_mnx_zone1_t;	/* zone number for V1 file systems */
typedef unsigned long	_mnx_zone2_t;	/* zone number for V2 file systems */
typedef unsigned short	_mnx_bitchunk_t; /* collection of bits in a bitmap */
typedef unsigned int	_mnx_ioreq_t;	/* ioctl request code */

typedef unsigned char	_mnx_u8_t;	/* 8 bit type */
typedef unsigned short	_mnx_u16_t;	/* 16 bit type */
typedef unsigned long	_mnx_u32_t;	/* 32 bit type */

typedef char		_mnx_i8_t;	/* 8 bit signed type */
typedef short		_mnx_i16_t;	/* 16 bit signed type */
typedef long		_mnx_i32_t;	/* 32 bit signed type */

/* The following types are needed because MINIX uses K&R style function
 * definitions (for maximum portability).  When a short, such as dev_t, is
 * passed to a function with a K&R definition, the compiler automatically
 * promotes it to an int.  The prototype must contain an int as the parameter,
 * not a short, because an int is what an old-style function definition
 * expects.  Thus using dev_t in a prototype would be incorrect.  It would be
 * sufficient to just use int instead of dev_t in the prototypes, but Dev_t
 * is clearer.
 */
typedef int		_mnx_Dev_t;
typedef int		_mnx_Gid_t;
typedef int		_mnx_Uid_t;
typedef int		_mnx_U8_t;
typedef unsigned long	_mnx_U32_t;
typedef int		_mnx_I8_t;
typedef int		_mnx_I16_t;
typedef long		_mnx_I32_t;

/* ANSI C makes writing down the promotion of unsigned types very messy.  When
 * sizeof(short) == sizeof(int), there is no promotion, so the type stays
 * unsigned.  When the compiler is not ANSI, there is usually no loss of
 * unsignedness, and there are usually no prototypes so the promoted type
 * doesn't matter.  The use of types like Ino_t is an attempt to use ints
 * (which are not promoted) while providing information to the reader.
 */

#if _WORD_SIZE == 2
typedef unsigned int	_mnx_Ino_t;
typedef unsigned int	_mnx_Nlink_t;
typedef unsigned int	_mnx_Zone1_t;
typedef unsigned int	_mnx_Bitchunk_t;
typedef unsigned int	_mnx_U16_t;
typedef unsigned int	_mnx_Mode_t;
#endif /* _WORD_SIZE == 2 */

#if _WORD_SIZE == 4
typedef int		_mnx_Ino_t;
typedef int		_mnx_Nlink_t;
typedef int		_mnx_Zone1_t;
typedef int		_mnx_Bitchunk_t;
typedef int		_mnx_U16_t;
typedef int		_mnx_Mode_t;
#endif /* _WORD_SIZE == 4 */
 
#endif /* _MINIX__TYPES_H */

/*
 * $PchId: types.h,v 1.4 1995/11/17 22:48:35 philip Exp $
 */
