/* Prototypes for system library functions. */

#ifndef _MINIX__SYSLIB_H
#define _MINIX__SYSLIB_H

#include <minix/ansi.h>
#include <minix/types.h>
_C_BEGIN

/* Hide names to avoid name space pollution. */
#define sendrec		_sendrec
#define receive		_receive
#define send		_send
#define sys_abort	_sys_abort
#define sys_adj_data	_sys_adj_data
#define sys_adj_stack	_sys_adj_stack
#define sys_adjmap	_sys_adjmap
#define sys_copy	_sys_copy
#define sys_core	_sys_core
#define sys_delmap	_sys_delmap
#define sys_dupseg	_sys_dupseg
#define sys_exec	_sys_exec
#define sys_findproc	_sys_findproc
#define sys_fork	_sys_fork
#define sys_fresh	_sys_fresh
#define sys_getmap	_sys_getmap
#define sys_getsig	_sys_getsig
#define sys_getsp	_sys_getsp
#define sys_kill	_sys_kill
#define sys_newmap	_sys_newmap
#define sys_nice	_sys_nice
#define sys_oldsig	_sys_oldsig
#define sys_puts	_sys_puts
#define sys_sendsig	_sys_sendsig
#define sys_sig		_sys_sig
#define sys_sigreturn	_sys_sigreturn
#define sys_swapoff	_sys_swapoff
#define sys_sysctl	_sys_sysctl
#define sys_sysenv	_sys_sysenv
#define sys_times	_sys_times
#define sys_trace	_sys_trace
#define sys_umap	_sys_umap
#define sys_vm_lock	_sys_vm_lock
#define sys_vm_unlock	_sys_vm_unlock
#define sys_xit		_sys_xit

/* Minix user+system library. */
_PROTOTYPE( void printk, (char *_fmt, ...)				);
_PROTOTYPE( int sendrec, (int _src_dest, message *_m_ptr)		);
_PROTOTYPE( int _taskcall, (int _who, int _syscallnr, message *_msgptr)	);

/* Minix system library. */
_PROTOTYPE( int receive, (int _src, message *_m_ptr)			);
_PROTOTYPE( int send, (int _dest, message *_m_ptr)			);

_PROTOTYPE( int sys_abort, (int _how, ...)				);
_PROTOTYPE( phys_bytes sys_umap, (int _proc, int _space, vir_bytes _buf,
						vir_bytes _size)	);
_PROTOTYPE( int sys_copy, (int _src_proc, int _src_space, 
	phys_bytes _src_buf, int _dst_proc, int _dst_space, 
	phys_bytes _dst_buf, phys_bytes _bytes)				);
_PROTOTYPE( int sys_getsp, (int _proc, vir_bytes *_newsp)		);
_PROTOTYPE( int sys_kill, (int _proc, int _sig)				);
_PROTOTYPE( int sys_getmap, (int _proc, struct mem_map *_ptr)		);
_PROTOTYPE( int sys_adj_data, (int _proc, vir_bytes _break_ptr)		);
_PROTOTYPE( int sys_adj_stack, (int _proc, vir_bytes _stack_ptr)	);
_PROTOTYPE( int sys_sig, (int _proc, int _sig, 
					_mnx_sighandler_t _sighandler)	);
_PROTOTYPE( int sys_times, (int _proc, _mnx_clock_t _ptr[5])		);
_PROTOTYPE( int sys_trace,(int _req, int _procnr, long _addr, long *_data_p));
_PROTOTYPE( int sys_xit, (int _parent, int _proc)			);
_PROTOTYPE( int sys_sysenv, (int _proc, char *_key, int _keylen, char *_val, 
							int _vallen)	);

_PROTOTYPE( int sys_core, (int _proc, void *_ptr, int _len)		);
_PROTOTYPE( int sys_swapoff, (int _segm)				);
_PROTOTYPE( int sys_vm_lock, (int _proc, vir_bytes _addr, 
						vir_bytes _count)	);
_PROTOTYPE( int sys_vm_unlock, (int _proc, vir_bytes _addr, 
						vir_bytes _count)	);
_PROTOTYPE( int sys_puts, (char *_addr, unsigned _count)		);
_PROTOTYPE( int sys_findproc, (char *_name, int *_proc_nr, int _flags)	);
_PROTOTYPE( int sys_adjmap, (int _proc, struct mem_map *_ptr, 
		vir_clicks _data_clicks, vir_clicks _sp)		);
_PROTOTYPE( int sys_exec, (int _proc, int _srcproc, vir_bytes _initial_sp,
	int _traced, char *_name, vir_bytes _initial_pc)		);
_PROTOTYPE( int sys_fork, (int _parent, int _child, int _pid, 
					phys_clicks _shadow)		);
_PROTOTYPE( int sys_fresh, (int _proc, struct mem_map *_ptr, 
	phys_clicks _dc, phys_clicks *_basep, phys_clicks *_sizep)	);
_PROTOTYPE( int sys_newmap, (int _proc, struct mem_map *_ptr)		);
_PROTOTYPE( int sys_nice, (int _proc, unsigned long _quantum)		);
_PROTOTYPE( int sys_delmap, (int _proc)					);
_PROTOTYPE( int sys_dupseg, (int _srcproc, int _dstproc, int _segmbits)	);
_PROTOTYPE( int sys_sendsig, (int _proc, struct sigmsg *_ptr)		);
_PROTOTYPE( int sys_oldsig, (int _proc, int _sig,
					_mnx_sighandler_t _sighandler)	);
_PROTOTYPE( int sys_getsig, (int *_proc, _mnx_sigset_t *_set)		);
_PROTOTYPE( int sys_sigreturn, (int _proc, vir_bytes _scp, int _flags)	);
_PROTOTYPE( int sys_sysctl, (int _proc, _mnx_ioreq_t _request,
						vir_bytes _argp)	);
_C_END
#endif /* _MINIX__SYSLIB_H */

/*
 * $PchId: syslib.h,v 1.4 1995/11/17 22:49:25 philip Exp $
 */
