/* This file contains the table used to map system call numbers onto the
 * routines that perform them. This table is included by both mm and fs.
 * However, since most of the calls which are implemented by fs are not
 * implemented by mm and vice versa, define those unimplemented functions
 * to no_sys. Also, some calls share one function. This is also handled with
 * macros.
 */


#if MM_SCALL_TABLE
#define do_exit		do_mm_exit	/* 1 */
#define do_read		no_sys		/* 3 */
#define do_write	no_sys		/* 4 */
#define do_open		no_sys		/* 5 */
#define do_close	no_sys		/* 6 */
#define do_wait		do_waitpid	/* 7 */
#define do_creat	no_sys		/* 8 */
#define do_link		no_sys		/* 9 */
#define do_unlink	no_sys		/* 10 */
#define do_chdir	no_sys		/* 12 */
#define do_time		no_sys		/* 13 */
#define do_mknod	no_sys		/* 14 */
#define do_chmod	no_sys		/* 15 */
#define do_chown	no_sys		/* 16 */
#define do_break	do_brk		/* 17 */
#define do_stat		no_sys		/* 18 */
#define do_lseek	no_sys		/* 19 */
#define do_getpid	do_getset	/* 20 */
#define do_mount	no_sys		/* 21 */
#define do_umount	no_sys		/* 22 */
#define do_setuid	do_getset	/* 23 */
#define do_getuid	do_getset	/* 24 */
#define do_stime	no_sys		/* 25 */
#define do_ptrace	do_trace	/* 26 */
#define do_fstat	no_sys		/* 28 */
#define do_utime	no_sys		/* 30 */
#define do_access	no_sys		/* 33 */
#define do_sync		no_sys		/* 36 */
#define do_cpt_rename	do_rename	/* 38, 65 */
#define do_cpt_mkdir	do_mkdir	/* 39, 66 */
#define do_cpt_rmdir	do_rmdir	/* 40, 67 */
#define do_dup		no_sys		/* 41 */
#define do_pipe		no_sys		/* 42 */
#define do_times	no_sys		/* 43 */
#define do_setgid	do_getset	/* 46 */
#define do_getgid	do_getset	/* 47 */
#define do_ioctl	no_sys		/* 54 */
#define do_cpt_fcntl	do_fcntl	/* 55, 68 */
#define do_exece	do_exec		/* 59 */
#define do_umask	no_sys		/* 60 */
#define do_chroot	no_sys		/* 61 */
#define do_rename	no_sys		/* 97 */
#define do_mkdir	no_sys		/* 98 */
#define do_rmdir	no_sys		/* 99 */
#define do_fcntl	no_sys		/* 100 */
#define do_ioctl3	no_sys		/* 104 */
#define do_sysuname	no_sys		/* 105 */
#define do_gsgroups	do_getset	/* 111 */
#define do_slink	no_sys		/* 113 */
#define do_rdlink	no_sys		/* 114 */
#define do_lstat	no_sys		/* 115 */
#define do_fcancel	no_sys		/* 117 */
#define do_fwait	no_sys		/* 118 */
#define do_sysutime	no_sys		/* 121 */
#define do_unpause	no_sys		/* 129 */
#define do_revive	no_sys		/* 131 */
#define do_taskrepl	no_sys		/* 132 */
#define do_nrevive	no_sys		/* 133 */
#endif /* MM_SCALL_TABLE */

#if FS_SCALL_TABLE
#define do_wait		no_sys		/* 7 */
#define do_cpt_waitpid	do_waitpid	/* 11, 64 */
#define do_break	no_sys		/* 17 */
#define do_getpid	no_sys		/* 20 */
#define do_setuid	do_set		/* 23 */
#define do_getuid	no_sys		/* 24 */
#define do_ptrace	no_sys		/* 26 */
#define do_alarm	no_sys		/* 27 */
#define do_pause	no_sys		/* 29 */
#define do_nice		no_sys		/* 34 */
#define do_kill		no_sys		/* 37 */
#define do_times	do_tims		/* 43 */
#define do_setgid	do_set		/* 46 */
#define do_getgid	no_sys		/* 47 */
#define do_signal	no_sys		/* 48 */
#define do_exece	do_exec		/* 59 */
#define do_cpt_setsid	no_sys		/* 62, 101 */
#define do_cpt_getpgrp	no_sys		/* 63, 103 */
#define do_cpt_sigaction do_sigaction	/* 71, 106 */
#define do_cpt_sigsuspend do_sigsuspend	/* 72, 107 */
#define do_cpt_sigpending do_sigpending	/* 73, 108 */
#define do_cpt_sigprocmask do_sigprocmask/*74, 109 */
#define do_cpt_sigreturn do_sigreturn	/* 75, 110 */
#define do_cpt_reboot	no_sys		/* 76 */
#define do_waitpid	no_sys		/* 96 */
#define do_rmdir	do_unlink	/* 99 */
#define do_getpgrp	no_sys		/* 103 */
#define do_sigaction	no_sys		/* 106 */
#define do_sigsuspend	no_sys		/* 107 */
#define do_sigpending	no_sys		/* 108 */
#define do_sigprocmask	no_sys		/* 109 */
#define do_sigreturn	no_sys		/* 110 */
#define do_gsgroups	do_set		/* 111 */
#define do_sysenv	no_sys		/* 119 */
#define do_swapoff	no_sys		/* 120 */
#define do_ksig		no_sys		/* 128 */
#define do_taskrepl	no_sys		/* 132 */
#endif /* FS_SCALL_TABLE */

PUBLIC _PROTOTYPE (int (*scall_table[NCALLS]), (void) ) =
{
	/* V7 system calls. */
	no_sys,		/*  0 = (indir)		*/
	do_exit,	/*  1 = exit		*/
	do_fork,	/*  2 = fork		*/
	do_read,	/*  3 = read		*/
	do_write,	/*  4 = write		*/
	do_open,	/*  5 = open		*/
	do_close,	/*  6 = close		*/
	do_wait,	/*  7 = wait		*/
	do_creat,	/*  8 = creat		*/
	do_link,	/*  9 = link		*/
	do_unlink,	/* 10 = unlink		*/
	do_cpt_waitpid,	/* 11 = (exec) compat: waitpid		*/
	do_chdir,	/* 12 = chdir		*/
	do_time,	/* 13 = time		*/
	do_mknod,	/* 14 = mknod		*/
	do_chmod,	/* 15 = chmod		*/
	do_chown,	/* 16 = chown		*/
	do_break,	/* 17 = break		*/
	do_stat,	/* 18 = stat		*/
	do_lseek,	/* 19 = lseek		*/
	do_getpid,	/* 20 = getpid		*/
	do_mount,	/* 21 = mount		*/
	do_umount,	/* 22 = umount		*/
	do_setuid,	/* 23 = setuid		*/
	do_getuid,	/* 24 = getuid		*/
	do_stime,	/* 25 = stime		*/
	do_ptrace,	/* 26 = ptrace		*/
	do_alarm,	/* 27 = alarm		*/
	do_fstat,	/* 28 = fstat		*/
	do_pause,	/* 29 = pause		*/
	do_utime,	/* 30 = utime		*/
	no_sys,		/* 31 = (stty)		*/
	no_sys,		/* 32 = (gtty)		*/
	do_access,	/* 33 = access		*/
	do_nice,	/* 34 = nice		*/
	no_sys,		/* 35 = (ftime)		*/
	do_sync,	/* 36 = sync		*/
	do_kill,	/* 37 = kill		*/
	do_cpt_rename,	/* 38 = (unused) compat: rename		*/
	do_cpt_mkdir,	/* 39 = (unused) compat: mkdir		*/
	do_cpt_rmdir,	/* 40 = (unused) compat: rmdir		*/
	do_dup,		/* 41 = dup		*/
	do_pipe,	/* 42 = pipe		*/
	do_times,	/* 43 = times		*/
	no_sys,		/* 44 = (prof)		*/
	no_sys,		/* 45 = (unused)	*/
	do_setgid,	/* 46 = setgid		*/
	do_getgid,	/* 47 = getgid		*/
	do_signal,	/* 48 = signal		*/
	no_sys,		/* 49 = (unused)	*/
	no_sys,		/* 50 = (unused)	*/
	no_sys,		/* 51 = (acct)		*/
	no_sys,		/* 52 = (phys)		*/
	no_sys,		/* 53 = (lock)		*/
	do_ioctl,	/* 54 = ioctl		*/
	do_cpt_fcntl,	/* 55 = (unused) compat: fcntl		*/
	no_sys,		/* 56 = (mpx)		*/
	no_sys,		/* 57 = (unused)	*/
	no_sys,		/* 58 = (unused)	*/
	do_exece,	/* 59 = exece		*/
	do_umask,	/* 60 = umask		*/
	do_chroot,	/* 61 = chroot		*/
	do_cpt_setsid,	/* 62 = (unused) compat: setsid		*/
	do_cpt_getpgrp,	/* 63 = (unused) compat: getpgrp	*/

	/* Standard Minix extensions. */
	no_sys,		/* 64 = (unused)	*/
	no_sys,		/* 65 = (unused)	*/
	no_sys,		/* 66 = (unused)	*/
	no_sys,		/* 67 = (unused)	*/
	no_sys,		/* 68 = (unused)	*/
	no_sys,		/* 69 = (unused)	*/
	no_sys,		/* 70 = (unused)	*/
	do_cpt_sigaction,  /* 71 = (unused) compat: sigaction	*/
	do_cpt_sigsuspend, /* 72 = (unused) compat: sigsuspend	*/
	do_cpt_sigpending, /* 73 = (unused) compat: sigpending	*/
	do_cpt_sigprocmask,/* 74 = (unused) compat: sigprocmask	*/
	do_cpt_sigreturn,  /* 75 = (unused) compat: sigreturn	*/
	do_cpt_reboot,	/* 76 = (unused) compat: reboot		*/
	no_sys,		/* 77 = (unused)	*/
	no_sys,		/* 78 = (unused)	*/
	no_sys,		/* 79 = (unused)	*/
	no_sys,		/* 80 = (unused)	*/
	no_sys,		/* 81 = (unused)	*/
	no_sys,		/* 82 = (unused)	*/
	no_sys,		/* 83 = (unused)	*/
	no_sys,		/* 84 = (unused)	*/
	no_sys,		/* 85 = (unused)	*/
	no_sys,		/* 86 = (unused)	*/
	no_sys,		/* 87 = (unused)	*/
	no_sys,		/* 88 = (unused)	*/
	no_sys,		/* 89 = (unused)	*/
	no_sys,		/* 90 = (unused)	*/
	no_sys,		/* 91 = (unused)	*/
	no_sys,		/* 92 = (unused)	*/
	no_sys,		/* 93 = (unused)	*/
	no_sys,		/* 94 = (unused)	*/
	no_sys,		/* 95 = (unused)	*/

	/* POSIX related system calls for Minix-vmd. */
	do_waitpid,	/* 96 = waitpid		*/
	do_rename,	/* 97 = rename		*/
	do_mkdir,	/* 98 = mkdir		*/
	do_rmdir,	/* 99 = rmdir		*/
	do_fcntl,	/* 100 = fcntl		*/
	do_setsid,	/* 101 = setsid		*/
	no_sys,		/* 102 = (setpgid)	*/
	do_getpgrp,	/* 103 = getpgrp	*/
	do_ioctl3,	/* 104 = new ioctl	*/
	do_sysuname,	/* 105 = sysuname	*/
	do_sigaction,	/* 106 = sigaction	*/
	do_sigsuspend,	/* 107 = sigsuspend	*/
	do_sigpending,	/* 108 = sigpending	*/
	do_sigprocmask,	/* 109 = sigprocmask	*/
	do_sigreturn,	/* 110 = sigreturn	*/
	do_gsgroups,	/* 111 = get/setgroups	*/

	/* Minix-vmd extensions. */
	do_reboot,	/* 112 = reboot		*/
	do_slink,	/* 113 = symlink	*/
	do_rdlink,	/* 114 = readlink	*/
	do_lstat,	/* 115 = lstat		*/
	no_sys,		/* 116 = (unused)	*/
	do_fcancel,	/* 117 = fcancel	*/
	do_fwait,	/* 118 = fwait		*/
	do_sysenv,	/* 119 = sysenv		*/
	do_swapoff,	/* 120 = swapoff	*/
	do_sysutime,	/* 121 = sysutime	*/
	do_svrctl,	/* 122 = svrctl		*/
	no_sys,		/* 123 = (unused)	*/
	no_sys,		/* 124 = (unused)	*/
	no_sys,		/* 125 = (unused)	*/
	no_sys,		/* 126 = (unused)	*/
	no_sys,		/* 127 = (unused)	*/

	/* Minix-vmd internals. */
	do_ksig,	/* 128 = KSIG: signals originating in the kernel	*/
	do_unpause,	/* 129 = UNPAUSE	*/
	no_sys,		/* 130 = (unused)	*/
	do_revive,	/* 131 = REVIVE		*/
	do_taskrepl,	/* 132 = TASK_REPLY	*/
	do_nrevive,	/* 133 = DEVICE_REPLY	*/
};

/*
 * $PchId: scalltab.h,v 1.5 1995/11/17 22:50:15 philip Exp $
 */
