/*	minix/partition.h				Author: Kees J. Bot
 *								7 Dec 1995
 * Place of a partition on disk and the disk geometry,
 * for use with the DIOCGETP and DIOCSETP ioctl's.  Also declarations
 * of 64 bit disk addresses and functions to manipulate them.
 */
#ifndef _MINIX__PARTITION_H
#define _MINIX__PARTITION_H

#include <minix/ansi.h>
#include <minix/types.h>
_C_BEGIN

typedef struct { _mnx_u32_t _[2]; } u64_t;

struct partition {
  u64_t base;			/* byte offset to the partition start */
  u64_t size;			/* number of bytes in the partition */
  unsigned cylinders;		/* disk geometry for partitioning */
  unsigned heads;
  unsigned sectors;
};

struct partition32 {		/* For standard Minix compatibility code. */
  _mnx_u32_t base, size;	/* 32 bit partition offsets */
  unsigned cylinders, heads, sectors;
};

u64_t add64(u64_t i, u64_t j);
u64_t add64u(u64_t i, unsigned j);
u64_t add64ul(u64_t i, unsigned long j);
u64_t sub64(u64_t i, u64_t j);
u64_t sub64u(u64_t i, unsigned j);
u64_t sub64ul(u64_t i, unsigned long j);
unsigned diff64(u64_t i, u64_t j);
u64_t cvu64(unsigned i);
u64_t cvul64(unsigned long i);
unsigned cv64u(u64_t i);
unsigned long cv64ul(u64_t i);
unsigned long div64u(u64_t i, unsigned j);
unsigned rem64u(u64_t i, unsigned j);
u64_t mul64u(unsigned long i, unsigned j);
int cmp64(u64_t i, u64_t j);
int cmp64u(u64_t i, unsigned j);
int cmp64ul(u64_t i, unsigned long j);
unsigned long ex64lo(u64_t i);
unsigned long ex64hi(u64_t i);
u64_t make64(unsigned long lo, unsigned long hi);

_C_END
#endif /* _MINIX__PARTITION_H */
