#ifndef _MINIX__MINLIB_H
#define _MINIX__MINLIB_H

#include <minix/ansi.h>
_C_BEGIN

/* Forward struct declarations. */
struct message;

/* Miscellaneous BSD. */
_PROTOTYPE(char *getpass, (const char *_prompt));

/* Miscellaneous MINIX. */
_PROTOTYPE(char *itoa, (int _n));
_PROTOTYPE(void std_err, (char *_s));
_PROTOTYPE(void prints, (const char *_s, ...));
_PROTOTYPE(int getprocessor, (void));
_PROTOTYPE(int i486_alignment_check, (int));

/* Library internals */
_PROTOTYPE(int _syscall, (int _who, int _syscallnr, 
						struct message *_msgptr));
_PROTOTYPE( void _m3_loadname, (struct message *_msgptr, const char *_name));
_PROTOTYPE( int __execve, (const char *_path, char *const _argv[], 
			char *const _envp[], int _nargs, int _nenvps)	);
_PROTOTYPE( void _begsig, (int _sig)					);

#define PROC_MM		0	/* process slot number of MM */
#define PROC_FS		1	/* process slot number of FS */

_C_END
#endif /* _MINIX__MINLIB_H */

/*
 * $PchId: minlib.h,v 1.4 1995/11/18 07:15:41 philip Exp $
 */
