/* System calls. */
#define SEND		   1	/* function code for sending messages */
#define RECEIVE		   2	/* function code for receiving messages */
#define SENDREC		   3	/* function code for SEND + RECEIVE */
#define ANY   (NR_PROCS+100)	/* receive(ANY, buf) accepts from any source */

/* Reply values. (apart from errors defined in <errno.h> */
#define SUSPEND	 -998	/* returned when a device has no data */

/* Task numbers, function codes and reply codes. */

#define SCSI_NAME	"SCSI"
#define CLOCK_NAME	"CLOCK"
#define CONS_NAME	"CONSOLE"
#define DOSDSK_NAME	"DOSDSK"
#define VDISK_NAME	"VDISK"
#define DP8390_NAME	"DP8390"
#define FLOPPY_NAME	"FLOPPY"
#define MEM_NAME	"MEMORY"
#define PAGER_NAME	"PAGER"
#define PRINTER_NAME	"PRINTER"
#define PTY_NAME	"PTY"
#define SERIAL_NAME	"RS232"
#define SYN_AL_NAME	"SYN_AL"
#define WINCHE_NAME	"WINCH"
#define CDROM_NAME	"CDROM"
#define AUDIO_NAME	"AUDIO"
#define MIXER_NAME	"MIXER"

/* For FS, assume multiple SCSI controllers. */
#define SCSI0_NAME	SCSI_NAME

/* Some tasks still have fixed positions */
#define IDLE              -3	/* task to run when there's nothing to run */
#define SYSTASK           -2	/* internal functions */
#define HARDWARE          -1	/* used as source on interrupt generated msgs*/

/* Operations on devices. */
#define DEV_OPEN     200	/* fcn code for opening a device */
#define DEV_CLOSE    201	/* fcn code for closing a device */
#define DEV_READ     202    	/* fcn code for reading from a device */
#define DEV_WRITE    203	/* fcn code for writing to a device */
#define DEV_IOCTL    204	/* fcn code for ioctl */
#define DEV_CANCEL   205	/* general req to force a task to cancel */
#define DEV_IOCTL3   206	/* fcn code for ioctl function that takes
				 * three parameters. */
#define DEV_SCATTER  207	/* fcn code for writing from a vector */
#define DEV_GATHER   208    	/* fcn code for reading into a vector */

#	define CANCEL_ANY	0
#undef CANCEL_ANY
#define CANCEL_ANY 666

#define HARD_INT     210	/* fcn code for all hardware interrupts */

/* Message types for datalink layer reqests. */
#define DL_WRITE	220
#define DL_WRITEV	221
#define DL_READ		222
#define DL_READV	223
#define DL_INIT		224
#define DL_STOP		225
#define DL_GETSTAT	226

/* Message types for data link layer replies. */
#define DL_INIT_REPLY	230
#define DL_TASK_REPLY	231

/* Field definitions */
#define DL_PORT		m2_i1
#define DL_PROC		m2_i2
#define DL_COUNT	m2_i3
#define DL_MODE		m2_l1
#define DL_CLCK		m2_l2
#define DL_ADDR		m2_p1

#define DL_STAT		m2_l1

/* Bits in `DL_STAT' field of DL replies. */
#define DL_PACK_SEND	0x01
#define DL_PACK_RECV	0x02
#define DL_READ_IP	0x04

/* bits in `DL_MODE' field of DL requests */
#define DL_NOMODE	0x0
#define DL_PROMISC_REQ	0x2
#define DL_MULTI_REQ	0x4
#define DL_BROAD_REQ	0x8


/* Minor devices for the memory task */
#define NULL_MAJOR  1	/* major device for /dev/null */
#define RAM_DEV     0	/* minor device for /dev/ram */
#define MEM_DEV     1	/* minor device for /dev/mem */
#define KMEM_DEV    2	/* minor device for /dev/kmem */
#define NULL_DEV    3	/* minor device for /dev/null */
#define ZERO_DEV    5	/* minor device for /dev/zero */


#define SET_ALARM   240	/* fcn code to CLOCK, set up alarm */
#define GET_TIME	   241	/* fcn code to CLOCK, get real time */
#define SET_TIME	   242	/* fcn code to CLOCK, set real time */
#define GET_UPTIME  243	/* fcn code to CLOCK, get uptime */
#define SET_SYNC_AL 244	/* fcn code to CLOCK, set up alarm which */
				/* times out with a send */
#define SYS_UTIME   245	/* fcn code to CLOCK, do misc. functions with
				 * micro second resolution */
#define REAL_TIME   1	/* reply from CLOCK: here is real time */
#define CLOCK_INT   HARD_INT
				/* this code will only be sent by */
				/* SYN_ALRM_TASK to a task that requested a */
				/* synchronous alarm */

#define SYS_XIT     250	/* fcn code for sys_xit(parent, proc) */
#define SYS_GETSP   251	/* fcn code for sys_sp(proc, &new_sp) */
#define SYS_OLDSIG  252	/* fcn code for sys_oldsig(proc, sig) */
#define SYS_FORK    253	/* fcn code for sys_fork(parent, child) */
#define SYS_NEWMAP  254	/* fcn code for sys_newmap(procno, map_ptr) */
#define SYS_COPY    255	/* fcn code for sys_copy(ptr) */
#define SYS_EXEC    256	/* fcn code for sys_exec(procno, new_sp) */
#define SYS_TIMES   257	/* fcn code for sys_times(procno, bufptr) */
#define SYS_ABORT   258	/* fcn code for sys_abort() */
#define SYS_FRESH   259	/* fcn code for sys_fresh()  (Atari only) */
#define SYS_KILL    260	/* fcn code for sys_kill(proc, sig) */
#define SYS_REV     261	/* fcn code for sys_rev() */
#define SYS_UMAP    262	/* fcn code for sys_umap(procno, etc) */
#define SYS_MEM     263	/* fcn code for sys_mem() */
#define SYS_TRACE   264	/* fcn code for sys_trace(req,pid,addr,data) */
#define SYS_VCOPY   265	/* fnc code for sys_vcopy(src_proc, dest_proc,
					   vcopy_s, vcopy_ptr) */
#define SYS_NICE    266	/* fcn code for sys_nice(procno, incr) */
#define SYS_PROFIL  267	/* fcn code for sys_profil(pno,sc,sz,offs,buf)*/
#define SYS_CORE    268	/* fnc code for sys_core(proc, ptr, size) */
#define SYS_GETMAP  269	/* fnc code for sys_getmap(procno, map_ptr) */
#define SYS_SYSENV  272	/* fnc code for sys_sysenv(procno, ...) */

/* For paging VM */
#define SYS_SWAPOFF 273	/* fnc code for sys_swapoff(segm) */
#define SYS_VM_LOCK 274	/* fnc code for sys_vm_lock(proc, addr, count) */
#define SYS_VM_UNLOCK 275	/* fnc code for sys_vm_unlock(...) */

#define SYS_PUTS    276	/* fnc code for sys_puts(addr, count) */

#define SYS_SENDSIG 277	/* fcn code for sys_sendsig(&sigmsg) */
#define SYS_SIGRETURN 278	/* fcn code for sys_sigreturn(&sigmsg) */
#define SYS_GETSIG  280	/* fcn code for sys_getsig(&procno, &sigset) */
#define SYS_ADJDATA  281	/* fnc code for sys_adj_data(procno,
				 * break_ptr) */
#define SYS_ADJSTACK 282	/* fnc code for sys_adj_stack(procno,
				 * stack_ptr) */
#define SYS_DELMAP   283	/* fcn code for sys_delmap(proc) */
#define SYS_DUPSEG   284	/* fcn code for sys_dupseg(proc, segs) */
#define SYS_FINDPROC 285	/* fcn code for sys_findproc(name, &task_nr,
				 * flags) */
#define SYS_SYSCTL   286	/* fcn code for sys_sysctl(proc, req, argp) */

/* Thread synchronization. */
#define THREAD_SYNCH 290	/* fcn code for synchronization rendezvous */

/* Message types for the pager. */
#define PAGER_SWAPOUT	300
#define PAGER_SYNC	301

/* Names of message fields for messages to CLOCK task. */
#define DELTA_TICKS    m6_l1	/* alarm interval in clock ticks */
#define FUNC_TO_CALL   m6_f1	/* pointer to function to call */
#define NEW_TIME       m6_l1	/* value to set clock to (SET_TIME) */
#define CLOCK_PROC_NR  m6_i1	/* which proc (or task) wants the alarm? */
#define SECONDS_LEFT   m6_l1	/* how many seconds were remaining */

/* Names of message fields used for messages to block and character tasks. */
#define DEVICE         m2_i1	/* major-minor device */
#define PROC_NR        m2_i2	/* which (proc) wants I/O? */
#define COUNT          m2_i3	/* how many bytes to transfer */
#define POSITION       m2_l1	/* file offset */
#define REQUEST        m2_l1	/* ioctl request code */
#define ADDRESS        m2_p1	/* core buffer address */
#define HIGHPOS        m2_l3	/* high bits for a 64 bit file offset */

/* Names of message fields for messages to TTY task. */
#define TTY_LINE       DEVICE	/* message parameter: terminal line */
#define TTY_REQUEST    COUNT	/* message parameter: ioctl request code */
#define TTY_SPEK       POSITION	/* message parameter: ioctl speed, erasing */
#define TTY_FLAGS      m2_l2	/* message parameter: ioctl tty mode */
#define TTY_PGRP       m2_i3	/* message parameter: process group */	

/* Names of the message fields for QIC 02 status reply from tape driver */
#define TAPE_STAT0	m2_l1
#define TAPE_STAT1	m2_l2

#if _VMD_EXT
/* Names of message files for new device messages. */
#define NDEV_MINOR	m2_i1
#define NDEV_REPLY	m2_i1
#define NDEV_PROC	m2_i2
#define NDEV_REF	m2_i3
#define NDEV_POSITION	m2_l1
#define NDEV_MODE	m2_l1
#define NDEV_COUNT	m2_l2
#define NDEV_IOCTL	m2_l2
#define NDEV_OPERATION	m2_l2
#define NDEV_BUFFER	m2_p1
#define NDEV_HIGHPOS	m2_l3
#endif /* _VMD_EXT */

/* Names of messages fields used in reply messages from tasks. */
#define REP_PROC_NR    m2_i1	/* # of proc on whose behalf I/O was done */
#define REP_STATUS     m2_i2	/* bytes transferred or error number */
#if _VMD_EXT
#define REP_REF	       m2_i3	/* reference */
#define REP_OPERATION  m2_l2	/* which operation. */
#endif /* _VMD_EXT */

/* Names of fields for copy message to SYSTASK. */
#define SRC_SPACE      m5_c1	/* T or D space (stack is also D) */
#define SRC_PROC_NR    m5_i1	/* process to copy from */
#define SRC_BUFFER     m5_l1	/* virtual address where data come from */
#define DST_SPACE      m5_c2	/* T or D space (stack is also D) */
#define DST_PROC_NR    m5_i2	/* process to copy to */
#define DST_BUFFER     m5_l2	/* virtual address where data go to */
#define COPY_BYTES     m5_l3	/* number of bytes to copy */

/* Field names for accounting, SYSTASK and miscellaneous. */
#define USER_TIME      m4_l1	/* user time consumed by process */
#define SYSTEM_TIME    m4_l2	/* system time consumed by process */
#define CHILD_UTIME    m4_l3	/* user time consumed by process' children */
#define CHILD_STIME    m4_l4	/* sys time consumed by process' children */
#define BOOT_TICKS     m4_l5	/* number of clock ticks since boot time */

#define PROC1          m1_i1	/* indicates a process */
#define PROC2          m1_i2	/* indicates a process */
#define PID            m1_i3	/* process id passed from MM to kernel */
#define STACK_PTR      m1_p1	/* used for stack ptr in sys_exec, sys_getsp */
#define PR             m6_i1	/* process number for sys_sig */
#define SIGNUM         m6_i2	/* signal number for sys_sig */
#define FUNC           m6_f1	/* function pointer for sys_sig */
#define MEM_PTR        m1_p1	/* tells where memory map is for sys_newmap */
#define NAME_PTR       m1_p2	/* tells where program name is for dmp */
#if _VMD_EXT
#define PROG_COUNT     m1_p3	/* used for pc in sys_exec */
#endif /* _VMD_EXT */
#define IP_PTR	       m1_p3	/* initial value for ip after exec */
#define SIG_PROC       m2_i1	/* process number for inform */
#define SIG_MAP        m2_l1	/* used by kernel for passing signal bit map */
#define SIG_MSG_PTR    m1_i1	/* pointer to info to build sig catch stack */
#define SIG_CTXT_PTR   m1_p1	/* pointer to info to restore signal context */

/*
 * $PchId: com.h,v 1.9 1996/04/10 19:31:59 philip Exp $
 */
