/*
minix/cfg_public.h

Define macros in the users name space based on defines in the implementors
name space.

Created:	Nov 21, 1992 by Philip Homburg
*/

#ifndef _MINIX__CFG_PUBLIC_H
#define _MINIX__CFG_PUBLIC_H

#include <minix/cfg_lib.h>

#define IBM_PC             1	/* any  8088 or 80x86-based system */
#define IBM_386		   2	/* any 386 (486) without virtual memory */
#define IBM_386_VM         3	/* any 386 (486) with virtual memory enabled */
#define SUN_4             40	/* any Sun SPARC-based system */
#define SUN_4_60	  40	/* Sun-4/60 (aka SparcStation 1 or Campus) */
#define ATARI             60	/* ATARI ST (68000) */
#define AMIGA             61	/* Commodore Amiga (68000) */
#define MACINTOSH         62	/* Apple Macintosh (68000) */

#if _INTEL_CPU
#if _INTEL_386_CPU
#if _VMDEXT_VIRT_MEM
#define MACHINE		IBM_386_VM
#else /* !_VMDEXT_VIRT_MEM */
#define MACHINE		IBM_386
#endif /* _VMDEXT_VIRT_MEM */
#else /* !_INTEL_386_CPU */
#define	MACHINE		IBM_PC
#endif /* _INTEL_386_CPU */
#endif /* _INTEL_CPU */


/* Set the CHIP type based on the machine selected. The symbol CHIP is actually
 * indicative of more than just the CPU.  For example, machines for which
 * CHIP == INTEL are expected to have 8259A interrrupt controllers and the
 * other properties of IBM PC/XT/AT/386 types machines in general. */
#define INTEL             1	/* CHIP type for PC, XT, AT, 386 and clones */
#define M68000            2	/* CHIP type for Atari, Amiga, Macintosh    */
#define SPARC             3	/* CHIP type for SUN-4 (e.g. SPARCstation)  */


/* Set the FP_FORMAT type based on the machine selected, either hw or sw    */
#define FP_NONE		  0	/* no floating point support                */
#define FP_IEEE		  1	/* conform IEEE floating point standard     */


/* Common defines */
#define ROBUST			_FS_ROBUST
#define NR_BUFS			_FS_NR_BUFS
#define NR_BUF_HASH		_FS_NR_BUF_HASH
#define I_MAP_SLOTS     	_FS_I_MAP_SLOTS
#define Z_MAP_SLOTS     	_FS_Z_MAP_SLOTS
#define ENABLE_NETWORKING	_VMDEXT_TCPIP
#define ALLOW_USER_SEND		_KERNEL_PROC_USER_SEND
#define PROFILING		_VMDEXT_PROFILING
#define NEW_CORE_FORMAT		_VMDEXT_NEW_CORE_FORMAT
#define VMDEXT_NEW_CORE_FORMAT	_VMDEXT_NEW_CORE_FORMAT
#define NEW_DEVMAP_CODE		_VMDEXT_FS_DEVMAP
#define NEW_MM_FS_INIT		_VMDEXT_MEMINIT
#define VMDEXT_MEMINIT		_VMDEXT_MEMINIT
#define INCL_REBOOT		_VMDEXT_REBOOT
#define VMDEXT_REBOOT		_VMDEXT_REBOOT
#define NEW_TTY_CODE		_VMDEXT_TERMIOS
#define VMDEXT_TTY_SESSION	_VMDEXT_TTY_SESSION
#define FAST_WINI_CODE		_VMDEXT_DISKDRIVER
#define NEW_SCHED		_VMDEXT_SCHED
#define VMDEXT_SCHED		_VMDEXT_SCHED
#define VIRT_MEM		_VMDEXT_VIRT_MEM
#define PAGING_VM		_VMDEXT_PAGING
#define LOADAV			_VMDEXT_LOADAV
#define PCH_KERNEL_EXT		_VMDEXT_PCH_KERNEL_EXT
#define PCH_MM_EXT		_VMDEXT_PCH_MM_EXT
#define PCH_FS_EXT		_VMDEXT_PCH_FS_EXT
#define _PKG_LOG		_VMDEXT_LOG
#define VMDEXT_LOG		_VMDEXT_LOG
#define FLOPPY_TIMING		_KERNEL_FLOPPY_TIMING
#define MONITOR			_KERNEL_MONITOR
#define RECORD_FLOPPY_SKEW	_KERNEL_RECORD_FLOPPY_SKEW
#define STACK_SAFETY_CLICKS	_USTACK_SAFETY_CLICKS
#define WORD_SIZE		_WORD_SIZE
#define SEGMENTED_MEMORY	_SEGMENTED_MEMORY
#define CLICK_SIZE		_CLICK_SIZE
#define CLICK_SHIFT		_CLICK_SHIFT
#define ASKDEV			_FS_ASK_BOOTDEV
#define FASTLOAD		_FS_FASTLOAD_RAM
#define VMDEXT_SMALL_IOVEC	_VMDEXT_SMALL_IOVEC
#define VMDEXT_SYSCALL		_VMDEXT_SYSCALL
#define VMDEXT_SYSUTIME		_VMDEXT_SYSUTIME
#define VMDEXT_SYSENV		_VMDEXT_SYSENV
#define VMDEXT_CLRMSG		_VMDEXT_CLRMSG
#define VMDEXT_FPU		_VMDEXT_FPU

/* Kernel specific configuration macros */
#define VMDEXT_KERNEL_LINMAP	_VMDEXT_KERNEL_LINMAP

/* MM specific configuration macros */
#define VMDEXT_MM_SIGNAL	_VMDEXT_MM_SIGNAL
#define VMDEXT_MM_EXEC		_VMDEXT_MM_EXEC
#define VMDEXT_MM_HASHBANG	_VMDEXT_MM_HASHBANG
#define VMDEXT_MM_NEWEXEC	_VMDEXT_MM_NEWEXEC

/* FS specific configuration macros */
#define FLEX			_VMDEXT_FLEXDIR
#define VMDEXT_FLEXDIR		_VMDEXT_FLEXDIR
#define NEW_DEVMAP_CODE		_VMDEXT_FS_DEVMAP
#define VMDEXT_FS_DEVMAP	_VMDEXT_FS_DEVMAP
#define ASYNCH_IO		_VMDEXT_ASYNCH_IO
#define VMDEXT_ASYNCH_IO	_VMDEXT_ASYNCH_IO
#define VMDEXT_FS_FAST_CREATE	_VMDEXT_FS_FAST_CREATE
#define INCL_SYMLINKS		_VMDEXT_SYMLINK
#define VMDEXT_SYMLINK		_VMDEXT_SYMLINK
#define VMDEXT_FS_STICKY_DIR	_VMDEXT_FS_STICKY_DIR 		/* XXX */
#define VMDEXT_FS_KJB		_VMDEXT_FS_KJB	 		/* XXX */
#define VMDEXT_NEWMOUNT		_VMDEXT_NEWMOUNT	
#define VMDEXT_FS_NO_HD3	_VMDEXT_FS_NO_HD3	
#define VMDEXT_FS_STICKY_DIR	_VMDEXT_FS_STICKY_DIR	
#define VMDEXT_SYSUNAME		_VMDEXT_SYSUNAME	
#define VMDEXT_HIDDENDIRS	_VMDEXT_HIDDENDIRS	
#define VMDEXT_FS_CACHE		_VMDEXT_FS_CACHE	
#define VMDEXT_SUPPGROUPS	_VMDEXT_SUPPGROUPS	


#if _INTEL_CPU
/* Intel/ISA specific defines */
#define CHIP			INTEL
#define AUTO_BIOS		_KERNEL_WD_AUTOBIOS
#define C_RS232_INT_HANDLERS	_KERNEL_RS232_C_INT_HANDLERS
#define DEFAULT_CLASS		_KERNEL_FLOPPY_DFLT_CLASS
#define LINEWRAP		_KERNEL_CONS_LINEWRAP
#define SYM_TAB_IN_SIZES	_VMDEXT_SYM_TAB_IN_SIZES
#define IGNORE_NMI		_KERNEL_IGNORE_NMI
#define NEW_CONSOLE		_VMDEXT_CONSOLE
#define NEW_SERIAL		_VMDEXT_SERIAL
#define MAPPED_VGA		_VMDEXT_MAPPED_VGA
#define _PKG_RAWKBD		_VMDEXT_RAWKBD
#define SPARE_VIDEO_MEMORY	_KERNEL_SPARE_VIDEO_MEMORY
#define SPLIMITS		_KERNEL_SPLIMITS
#if _WORD_SIZE == 4
#define INTEL_32BITS		1		/* backward compatibility */
#endif /* _WORD_SIZE == 4 */

#endif /* _INTEL_CPU */


#if _ATARI_ARCH
/* Atari specific defines */
#define CHIP			M68000
#define KEYBOARD		_KEYBOARD
#define VT100			_VT100
#define PARTITINING		_PARTITIONING
#define SUPRA			_SUPRA
#define BMS			_BMS
#define ICD			_ICD
#define CBHD			_CBHD
#define EICKMANN		_EICKMANN
#define NR_HD_DRIVES		_NR_HD_DRIVES
#define NR_FD_DRIVES		_NR_FD_DRIVES
#define PAR_PRINTER		_PAR_PRINTER
#define HD_CLOCK		_HD_CLOCK

#endif /* _ATARI_ARCH */


#if _AMIGA_ARCH
/* Amiga specific defines */
#define CHIP			M68000

#endif /* _AMIGA_ARCH */


#if _MAC_ARCH
/* Macintosh specific defines */
#define CHIP		M68000

#endif /* _MAC_ARCH */


#if _SPARC_CPU
/* Sparc specific defines */
#define CHIP			SPARC
#define FP_FORMAT		FP_IEEE

#endif /* _SPARC_CPU */


#ifndef FP_FORMAT
#define FP_FORMAT		FP_NONE
#endif

#if !defined(MACHINE) || MACHINE == 0
# error		MACHINE is not defined or has an illegal value
#endif

#if !defined(CHIP) || CHIP == 0
# error		CHIP is not defined or has an illegal value
#endif
#define _CHIP	CHIP

#endif /* _MINIX__CFG_PUBLIC_H */

/*
 * $PchId: cfg_public.h,v 1.4 1995/11/18 07:20:14 philip Exp $
 */
