/*
minix/cfg_common.h

Define macros which are common to all minix versions.

Created:	Nov 21, 1992 by Philip Homburg
*/

#ifdef _MINIX__CFG_COMMON_H
# error		minix/cfg_common included twice
#endif

#define _MINIX__CFG_COMMON_H


/* Check if exactly one cpu is defined */
#if _INTEL_CPU + _M68000_CPU + _SPARC_CPU + _UNIX_CPU != 1
# error		exactly one cpu should be defined
#endif

/* Check if exactly one architecture is defined */
#if _PC_ARCH + _ISA_ARCH + _ATARI_ARCH + _AMIGA_ARCH + _MAC_ARCH + \
	_SUN4_ARCH + _UNIX_ARCH  != 1
# error		exactly one architecture should be defined
#endif

/* Check the byte order. The value of _BYTEORDER_16 should be such that
 * if _BYTEORDER_16 is stored in an u16_t then the bytes in memory should be
 * { 1, 2 }; The same goes for _BYTEORDER_32 and { 1, 2, 3, 4 }; This means
 * that on a little endian system _BYTEORDER_32 should be 0x04030201.
 * We assume that only pure little endian or pure big endian systems exist.
 */
#if _BYTEORDER_16 != 0x0102 && _BYTEORDER_16 != 0x0201
# error		strange value in _BYTEORDER_16
#endif
#if _BYTEORDER_32 != 0x01020304 && _BYTEORDER_32 != 0x04030201
# error		strange value in _BYTEORDER_32
#endif

#ifndef _FS_NR_BUF_HASH
/* _FS_NR_BUF_HASH is the number of entries in the filesystem buffer hash table.
 * this size must be a power of two. In general, the next power of two larger
 * than then number of buffers seems to be a good choise.
 */
#define _FS_NR_BUF_HASH		64     /* size of buf hash table */
#endif

#ifndef _FS_NR_BUFS
/* The buffer cache should be made as large as you can afford. This is 
 * architecture depended, so we assume that a resonable value is defined in the
 * architecture depended include file. We define a (small) value just in case.
 */
#define _FS_NR_BUFS		32     /* # blocks in the buffer cache */
#endif

#ifndef _FS_ROBUST
/* If _FS_ROBUST is set to 1, writes of i-node, directory, and indirect blocks
 * from the cache happen as soon as the blocks are modified.  This gives a more
 * robust, but slower, file system.  If it is set to 0, these blocks are not
 * given any special treatment, which may cause problems if the system crashes.
 */
#define _FS_ROBUST		 0	/* 0 for speed, 1 for robustness */
#endif

/* The number of map slots determines how big a disk partition can be.
 * Each I_MAP_SLOT allows 8K files; each Z_MAP_SLOT allows 8M of data.
 */
#ifndef _FS_I_MAP_SLOTS
#define _FS_I_MAP_SLOTS		 8	/* # of blocks in the inode bit map */
#endif
#ifndef _FS_Z_MAP_SLOTS
#define _FS_Z_MAP_SLOTS		16	/* # of blocks in the zone bit map */
#endif

#ifndef _KERNEL_PROC_USER_SEND
/* Debug option, allow user processes to call send and receive, this can be
 * used to debug device drivers by running them as a user process.
 */
#define _KERNEL_PROC_USER_SEND	 0
#endif

#ifndef _VMDEXT_CLRMSG
/* Clear unused parts of messages */
#define _VMDEXT_CLRMSG		 1
#endif

#ifndef _VMDEXT_FPU
/* This define enables support for a floating point unit. Since floating
 * point support is architecture depended, the default is off.
 */
#define _VMDEXT_FPU		 0
#endif

#ifndef _VMDEXT_MEMINIT
/* This define enables new memory initialization code in kernel, mm, and fs.
 * In the kernel, a list of memory chunks is maintained with operations like
 * chunk_add, chunk_del, chunk_find. The ramdisk driver allocates the ramdisk
 * itself, so fs only has to tell it the size of the ramdisk and not the 
 * position, thus fs doesn't have to know to position of init anymore. Since
 * the list of free chunks in kernel is uptodate when mm initialises, fs 
 * doesn't have tell mm about the ramdisk, mm just asks the kernel for memory.
 * For Intel machines, fs can ask the kernel for its position, so no need
 * to patch fs.
 */
#define _VMDEXT_MEMINIT		 1
#endif

#ifndef _VMDEXT_NEW_CORE_FORMAT
/* The old core format dumped a copy of the process structure (struct proc)
 * as header of the core file. This means that every change in struct proc
 * generates a new core format and requires all tools to be recompiled.
 * With _VMDEXT_NEW_CORE_FORMAT, a fixed header is used independend of 
 * struct proc.
 */ 
#define _VMDEXT_NEW_CORE_FORMAT	 1
#endif

#ifndef _VMDEXT_REBOOT
/* This define enables the code that implements the reboot system call. */
#define _VMDEXT_REBOOT		 1
#endif

#ifndef _VMDEXT_SYSCALL
/* This define enables the code that implements new system calls. */
#define _VMDEXT_SYSCALL		 1
#endif

#ifndef _VMDEXT_SYSENV
/* This define enables code that implements the sysenv system call. */
#define _VMDEXT_SYSENV			1
#endif

#ifndef _VMDEXT_SYSUTIME
/* This define enables the code that implements time related fuctions
 * with micro second resolution (in the interface).
 */
#define _VMDEXT_SYSUTIME		1
#endif

#ifndef _VMDEXT_TCPIP
/* The TCP/IP implementation requires an ethernet card, so TCP/IP is enabled
 * in the architecture dependend file.
 */
#define _VMDEXT_TCPIP			0
#endif

#ifndef _VMDEXT_KERNEL_PROFILING
/* Kernel profiling stores at each clocktick a stacktrace of the current task 
 * or server in a buffer, which is delivered to a user process. The stacktrace 
 * is machine depended and the clocktick should come from a separate timer 
 * channel. Therefor, profiling should be enabled in an architecture depended
 * include file.
 */
#define _VMDEXT_KERNEL_PROFILING	0
#endif

#ifndef _VMDEXT_KERNEL_LINMAP
/* _VMDEXT_KERNEL_LINMAP defines if the kernel data segment is linearly mapped,
 * i.e. if a phys_bytes address can be cast to a pointer and used directly
 * without phys_copy. The default is 0 since this option is architecture
 * dependent.
 */
#define _VMDEXT_KERNEL_LINMAP		0
#endif

#ifndef _VMDEXT_FS_DEVMAP
/* If _VMDEXT_FS_DEVMAP is defined, messages to devices are send by calling
 * a function like dev_opcl or dev_rw, instead of building a message, locating
 * the function to call based of the major device number. The requirement
 * to allocate major device number contigiously, starting with 1 is also 
 * dropped.
 */
#define _VMDEXT_FS_DEVMAP		1
#endif

#ifndef _VMDEXT_TTY_SESSION
/* This defines enables code in MM and FS to implement the posix setsid call. */
#define _VMDEXT_TTY_SESSION	1
#endif

#ifndef _VMDEXT_TERMIOS
/* This define enable the code for a new tty driver which replaces the old one.
 * The new tty driver implements the POSIX 1003.1 terminal interface termios
 * and emulates the old sgtty interface on top of termios. The interface
 * between the terminal driver and the device depended code is also changed to
 * make integration of other terminal drivers like pseudo-ttys easier. Since
 * the machine depended drivers need to be rewritten, _VMDEXT_TERMIOS is to be
 * enabled in the architecture depended include file.
 */
#define _VMDEXT_TERMIOS		 0
#endif

#ifndef _VMDEXT_SYMLINK
/* This define enables code for symbolic links in the filesystem and in the
 * header files.
 */
#define _VMDEXT_SYMLINK		 1
#endif

#ifndef _VMDEXT_FLEXDIR
/* This define enables code for flexible directory entries in fs and in the
 * header files. Flexible diretory entries allow filenames as large as 60
 * characters, allocated in chunks of 8 characters.
 */
#define _VMDEXT_FLEXDIR		 1
#endif

#ifndef _VMDEXT_NEWMOUNT	
/* This define enables the new mount system call that allows remounting and
 * handling different types of filesystem more elegantly, and includes such
 * things as no-suid mounting and a clean flag.
 */
#define _VMDEXT_NEWMOUNT	 1
#endif

#ifndef _VMDEXT_FS_NO_HD3	
/* This define disables the "feature" that FS looks for its root file system
 * on /dev/hd3 if the given root file system is a boot disk.  With this version
 * of Minix the disk partitioning is usually so that /dev/hd3 is not the root
 * file system, so the trick more dangerous than useful.
 */
#define _VMDEXT_FS_NO_HD3	 1
#endif

#ifndef _VMDEXT_FS_STICKY_DIR	
/* This define enables stricter control on tmp directories by setting a
 * sticky bit on them.  With a sticky bit set, only the owner of the file,
 * the owner of the directory or root may delete a file in the directory.
 */
#define _VMDEXT_FS_STICKY_DIR	 1
#endif

#ifndef _VMDEXT_SYSUNAME	
/* This define enables a kernel base uname() call, with the kernel supplying
 * the default values.
 */
#define _VMDEXT_SYSUNAME	 1
#endif

#ifndef _VMDEXT_HIDDENDIRS	
/* This define enables the so called "hidden directories", directories that
 * are automatically expanded to a file within them, say /bin automatically
 * becomes /bin/i86 or /bin/i386 depending on the kernel architecture.
 * Drawback: '@' at the end of a name becomes special (uncovers hidden dir).
 */
#define _VMDEXT_HIDDENDIRS	 1
#endif

#ifndef _VMDEXT_ASYNCH_IO
/* This define enables code for asynchonous I/O in fs and the header files. */
#define _VMDEXT_ASYNCH_IO	 1
#endif

#ifndef _VMDEXT_SMALL_IOVEC
/* This define enables code that splits a large iovec up in several pieces,
 * of size NR_IOREQS.
 */
#define _VMDEXT_SMALL_IOVEC	1
#endif

#ifndef _VMDEXT_FS_FAST_CREATE
/* This define enables code that creates large files faster. */
#define _VMDEXT_FS_FAST_CREATE	1
#endif

#ifndef _VMDEXT_FS_KJB
/* Enable misc. extensions to FS by Kees Bot <kjb@cs.vu.nl> */
#define _VMDEXT_FS_KJB		1
#endif


#ifndef _VMDEXT_SCHED
/* This define enables code for a new scheduler. */
#define _VMDEXT_SCHED		 1
#endif

#ifndef _VMDEXT_VIRT_MEM
/* This define enables virtual memory code. Virtual memory can be paging or 
 * non-paging, If the virtual memory is paging, _VMDEXT_PAGING should also
 * be defined. Since virtual memory is architecture dependend, the default here
 * is off.
 */
#define _VMDEXT_VIRT_MEM	 0
#endif

#ifndef _VMDEXT_PAGING
/* This define enables paging virtual memory. The difference in the machine
 * independed part of minix is that a paging virtual memory requires pages to 
 * be locked into memory at some places. If _VMDEXT_PAGING is enabled, 
 * _VMDEXT_VIRT_MEM should also be enabled. Since paging is architecture 
 * dependend, it should be enabled in an architecture depended header file.
 */
#define _VMDEXT_PAGING		 0
#endif
#if _VMDEXT_PAGING && !_VMDEXT_VIRT_MEM
# error		_VMDEXT_PAGING requires _VMDEXT_VIRT_MEM
#endif

#ifndef _VMDEXT_LOADAV
/* This define enables code in the kernel which keeps track of the load 
 * avarage.
 */
#define _VMDEXT_LOADAV		 1
#endif

#ifndef _VMDEXT_MM_EXEC
/* Enable (virtual memory)extensions to the exec code in MM. */
#define _VMDEXT_MM_EXEC		1
#endif

#ifndef _VMDEXT_MM_HASHBANG
/* Enable direct execution of #! scripts by MM. */
#define _VMDEXT_MM_HASHBANG	1
#endif

#ifndef _VMDEXT_MM_SIGNAL
/* The define enables extensions to the signal code in MM. */
#define _VMDEXT_MM_SIGNAL	1
#endif

#ifndef _VMDEXT_MM_NEWEXEC
/* Enable a new exec implementation */
#define _VMDEXT_MM_NEWEXEC	1
#endif

#ifndef _VMDEXT_PCH_KERNEL_EXT
/* Enable misc. changes in the kernel by Philip Homburg */
#define _VMDEXT_PCH_KERNEL_EXT	 1
#endif

#ifndef _VMDEXT_PCH_MM_EXT
/* Enable misc. changes in mm by Philip Homburg */
#define _VMDEXT_PCH_MM_EXT	 1
#endif

#ifndef _VMDEXT_PCH_FS_EXT
/* Enable misc. changes in fs by Philip Homburg */
#define _VMDEXT_PCH_FS_EXT	 1
#endif

#ifndef _VMDEXT_LOG
/* This define enables code for a log device. This device allows a user process
 * to get the debug messages generated in the kernel, mm, fs, etc. and allows
 * a user process to write a diagnostic on the console without a need to worry
 * about the mode of the tty.
 */
#define _VMDEXT_LOG		 1
#endif

#ifndef _VMDEXT_FS_CACHE
/* This define enables a few changes to the filesystem cache code:  File
 * readahead is made slightly more efficient.  The FS cache blocks are
 * aligned to there size in memory to make DMA easier (no page spanning
 * blocks, less double buffering.)
 */
#define _VMDEXT_FS_CACHE	 1
#endif

#ifndef _VMDEXT_SUPPGROUPS	
/* This define enables supplementary group id's. */
#define _VMDEXT_SUPPGROUPS	 1
#endif

/* These configuration defines control debugging and unfinished code. */
#ifndef _KERNEL_FLOPPY_TIMING
#define _KERNEL_FLOPPY_TIMING	 0
#endif
#ifndef _KERNEL_MONITOR
#define _KERNEL_MONITOR		 0
#endif
#ifndef _KERNEL_RECORD_FLOPPY_SKEW
#define _KERNEL_RECORD_FLOPPY_SKEW 0
#endif

#ifndef _USTACK_SAFETY_CLICKS
/* This define gives the size of the smallest gap between the data segment
 * and the stack segment which is allowed. On a system without virtual memory
 * this will cost real memory, so the default is small. 
 */
#define _USTACK_SAFETY_CLICKS	 2
#endif

#ifndef _WORD_SIZE
/* Of course we have no default for the wordsize since it should be equal to
 * sizeof(int).
 */
# error		_WORD_SIZE is not defined
#endif
#if _WORD_SIZE != 2 && _WORD_SIZE != 4
/* So far, we only use 16 or 32 bit processors. */
# error		strange value in _WORD_SIZE
#endif

#ifndef _SEGMENTED_MEMORY
/*
 * _SEGMENTED_MEMORY means that mem_phys points to virtual address 0 instead
 * of the virtual address mem_vir.
 * so far, only Intel processor have segmented memory. But a virtual memory
 * system might look like one. Therefor we have no default.
 */
# error		_SEGMENTED_MEMORY is not defined
#endif

/* _CLICK_SIZE and _CLICK_SHIFT should be defined in an architecture depended
 * include file. */
#ifndef _CLICK_SIZE
# error		_CLICK_SIZE is not defined
#endif
#ifndef _CLICK_SHIFT
# error		_CLICK_SHIFT is not defined
#endif

#ifndef _FS_ASK_BOOTDEV
/* Asking for the boot device in fs in very ugly, so the default is not to 
 * ask.
 */
#define _FS_ASK_BOOTDEV		 0
#endif

#ifndef _FS_FASTLOAD_RAM
/* Fastloading the ramdisk is also ugly (assumes that fs knows where the 
 * ramdisk is), so the default is also off.
 */
#define _FS_FASTLOAD_RAM	 0
#endif

/*
 * $PchId: cfg_common.h,v 1.4 1995/11/18 07:22:11 philip Exp $
 */
