/*
minix/callnr.h

Recreated from minix/callnr.h:	Aug 17, 1992 by Philip Homburg
*/
/* UNIX version 7 defined calls in the range 0..61, let's reserve the
 * range 0..63 for V7 calls that are implemented by Minix. V7 calls not
 * implemented by Minix are commented out. 
 * Unfortunately some undefined calls in the V7 space are used by Posix
 * Minix specific calls. Maybe these should be moved to higher numbers. */

#ifndef _MINIX__CALLNR_H
#define _MINIX__CALLNR_H

#define NCALLS		 134	/* number of system calls allowed */

#define INDIR		   0
#define EXIT		   1
#define FORK		   2
#define READ		   3
#define WRITE		   4
#define OPEN		   5
#define CLOSE		   6
#define WAIT		   7
#define CREAT		   8
#define LINK		   9
#define UNLINK		  10
#define V7_EXEC		  11	/* This call should implement the Minix WAITPID
				 * call for backward compatibility. */
#define CHDIR		  12
#define TIME		  13
#define MKNOD		  14
#define CHMOD		  15
#define CHOWN		  16
#define BRK		  17	/* should be called BREAK */
#define STAT		  18
#define LSEEK		  19
#define GETPID		  20
#define MOUNT		  21
#define UMOUNT		  22
#define SETUID		  23
#define GETUID		  24
#define STIME		  25
#define PTRACE		  26
#define ALARM		  27
#define FSTAT		  28
#define PAUSE		  29
#define UTIME		  30
#define STTY		  31
#define GTTY		  32
#define ACCESS		  33
#define NICE		  34
#define FTIME		  35
#define SYNC		  36
#define KILL		  37
#define V7_UNDEFINED_38	  38	/* This call should implement the Minix RENAME
				 * call for backward compatibility. */
#define V7_UNDEFINED_39	  39	/* This call should implement the Minix MKDIR
				 * call for backward compatibility. */
#define V7_UNDEFINED_40	  40	/* This call should implement the Minix RMDIR
				 * call for backward compatibility. */
#define DUP		  41
#define PIPE		  42
#define TIMES		  43
#define PROFIL		  44
#define V7_UNDEFINED_45	  45
#define SETGID		  46
#define GETGID		  47
#define SIGNAL		  48
#define V7_UNDEFINED_49	  49
#define V7_UNDEFINED_50	  50
#define ACCT		  51
#define PHYS		  52
#define LOCK		  53
#define OLD_IOCTL	  54
#define V7_UNDEFINED_55	  55	/* This call should implement the Minix FCNTL
				 * call for backward compatibility. */
#define MPXCHAN	  	  56
#define V7_UNDEFINED_57	  57
#define V7_UNDEFINED_58	  58
#define EXEC		  59	/* this is called EXECE in V7 */
#define UMASK		  60
#define CHROOT		  61
#define V7_UNDEFINED_62	  62
#define V7_UNDEFINED_63	  63

/* Standard Minix extensions. */
#define CPT_SIGACTION	  71
#define CPT_SIGSUSPEND	  72
#define CPT_SIGPENDING	  73
#define CPT_SIGPROCMASK	  74
#define CPT_SIGRETURN	  75
#define CPT_REBOOT	  76

/* POSIX related system calls for Minix-vmd. */
#define WAITPID		  96
#define RENAME		  97
#define MKDIR		  98
#define RMDIR		  99
#define FCNTL		 100
#define SETSID		 101
#define SETPGID		 102	/* Not implemented, return ENOSYS */
#define GETPGRP		 103
#define IOCTL		 104
#define SYSUNAME	 105	/* Get/set sys/utsname info */
#define SIGACTION	 106
#define SIGSUSPEND	 107
#define SIGPENDING	 108
#define SIGPROCMASK	 109
#define SIGRETURN	 110
#define GSGROUPS	 111	/* Supplementary group id's */

/* The following calls are Minix-vmd extensions. */
#define REBOOT		 112
#define SYMLINK		 113
#define READLINK	 114
#define LSTAT		 115
#define FCANCEL		 117	/* For Asyncronous I/O */
#define FWAIT		 118	/* For Asyncronous I/O */
#define SYSENV		 119	/* get MINIX environment variable */
#define SWAPOFF		 120	/* remove a partition of the list of swap
				 * partitions */
#define SYSUTIME	 121	/* misc time/timer operations with micro second
				 * resolution */
#define SVRCTL		 122	/* misc control operations on MM or FS */

/* The following are not system calls, but are processed like them. */
#define KSIG		 128	/* kernel detected a signal */
#define UNPAUSE		 129	/* to MM or FS: check for EINTR */
#define REVIVE		 131	/* to FS: revive a sleeping process */
#define TASK_REPLY	 132	/* to FS: reply code from tty task */
#define DEVICE_REPLY	 133	/* FS: reply code from a device */

#endif /* _MINIX__CALLNR_H */

/*
 * $PchId: callnr.h,v 1.3 1995/11/18 07:23:06 philip Exp $
 */
