/*
bsd-include/unistd.h

Created:	Sept 1994 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef _BSD__UNISTD_H
#define _BSD__UNISTD_H

#ifndef _MINIX_SOURCE
#define _MINIX_SOURCE
#endif

#include <mnx/time.h>
#include <sys/unistd.h>

int fsync _ARGS(( int __fd ));
int daemon _ARGS(( int __nochdir, int __noclose ));
int __bsd_getpagesize _ARGS(( void ));
int __bsd_getdtablesize _ARGS(( void ));
int vfork _ARGS(( void ));
int revoke _ARGS(( const char *name ));

/* libutil */
struct termios;
struct winsize;
int openpty _ARGS(( int *amaster, int *aslave, char *name,
	struct termios *termp, struct winsize *winp ));
int forkpty _ARGS(( int *amaster, char *name, struct termios *termp,
	struct winsize *winp ));
int login_tty _ARGS(( int fd ));

#define getpagesize() (__bsd_getpagesize())
#define getdtablesize() (__bsd_getdtablesize())
#define vfork() (fork())

#endif /* _BSD__UNISTD_H */

/*
 * $PchId: unistd.h,v 1.1 1995/12/22 22:36:43 philip Exp $
 */
