/*
bsd-include/sys/param.h

Created:	Sept 1994 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef _BSD__SYS__PARAM_H
#define _BSD__SYS__PARAM_H

#ifndef _POSIX_SOURCE
#define _POSIX_SOURCE
#endif

#include <sys/types.h>

#include <mnx/limits.h>

#define MAXPATHLEN	PATH_MAX
#define MAXHOSTNAMELEN	256		/* max hostname size */

#define ALIGNBYTES	3
#define ALIGN(p)	(((u_int)(p) + ALIGNBYTES) &~ ALIGNBYTES)

#define roundup(x,y)	((((x)+((y)-1))/(y))*(y))
#define	MIN(a,b) (((a)<(b))?(a):(b))
#define	MAX(a,b) (((a)>(b))?(a):(b))

#define MACHINE		"i386"

#endif /* _BSD__SYS__PARAM_H */

/*
 * $PchId: param.h,v 1.2 1996/01/19 21:52:49 philip Exp $
 */
