/*
bsd-include/netinet/in.h

Created:	Sept 1994 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef _BSD__NETINET__IN_H
#define _BSD__NETINET__IN_H

#include <mnx/minix/types.h>
#include <mnx/net/gen/in.h>
#include <mnx/net/gen/udp.h>
#include <mnx/net/gen/udp_hdr.h>
#include <mnx/net/gen/udp_io.h>
#include <mnx/net/hton.h>
#include <mnx/net/netlib.h>

struct in_addr
{
	_mnx_u32_t	s_addr;
};

struct sockaddr_in
{
	_mnx_u8_t	sin_len;
	_mnx_u8_t	sin_family;
	_mnx_u16_t	sin_port;
	struct in_addr	sin_addr;
	char		sin_zero[8];
};

#define	INADDR_ANY		(u_long)0x00000000
#define	INADDR_BROADCAST	(u_long)0xffffffff	/* must be masked */
#define	INADDR_NONE		0xffffffff              /* -1 return */
#define IPPORT_RESERVED		1024

#define	IN_CLASSA(i)		(((long)(i) & 0x80000000) == 0)
#define	IN_CLASSA_NET		0xff000000
#define	IN_CLASSA_NSHIFT	24
#define	IN_CLASSA_HOST		0x00ffffff

#define	IN_CLASSB(i)		(((long)(i) & 0xc0000000) == 0x80000000)
#define	IN_CLASSB_NET		0xffff0000
#define	IN_CLASSB_NSHIFT	16
#define	IN_CLASSB_HOST		0x0000ffff

#define	IN_CLASSC(i)		(((long)(i) & 0xe0000000) == 0xc0000000)
#define	IN_CLASSC_NET		0xffffff00
#define	IN_CLASSC_NSHIFT	8
#define	IN_CLASSC_HOST		0x000000ff

#endif /* _BSD__NETINET__IN_H */

/*
 * $PchId: in.h,v 1.2 1996/01/19 21:55:35 philip Exp $
 */
