/****************************************************************/
/* Character attribute routines of the PCcurses package		*/
/*								*/
/****************************************************************/
/* This version of curses is based on ncurses, a curses version	*/
/* originally written by Pavel Curtis at Cornell University.	*/
/* I have made substantial changes to make it run on IBM PC's,	*/
/* and therefore consider myself free make it public domain.	*/
/*		Bjorn Larsson (...mcvax!enea!infovax!bl)	*/
/****************************************************************/
/* 1.0:	Release:					870515	*/
/****************************************************************/
/* Modified to run under the MINIX operating system by Don Cope */
/* These changes are also released into the public domain.      */
/* 							900906  */
/****************************************************************/

#include <curses.h>
#include "curspriv.h"

/****************************************************************/
/* Wattrset() sets the attributes as specified in window 'win'.	*/
/****************************************************************/

void wattrset(win,attrs)
  WINDOW	*win;
  int		 attrs;
  {
  win->_attrs = attrs & ATR_MSK;
  } /* wattrset */

/****************************************************************/
/* Wattron() sets the specified attribute(s) in window 'win'.	*/
/****************************************************************/

void	wattron(win,attrs)
  WINDOW	*win;
  int		 attrs;
  {
  	win->_attrs |= (attrs & ATR_MSK);
  } /* wattron */

/****************************************************************/
/* Wattroff() clears the specified attribute(s) in window	*/
/* 'win'.							*/
/****************************************************************/

void	wattroff(win,attrs)
  WINDOW	*win;
  int		 attrs;
  {
  win->_attrs &= (~attrs & ATR_MSK);
  } /* wattroff */

/****************************************************************/
/* Wstandout() starts standout mode in window 'win'.		*/
/****************************************************************/

void	wstandout(win)
  WINDOW	*win;
  {
  win->_attrs |= A_STANDOUT;
  } /* wstandout */

/****************************************************************/
/* Wstandend() clears all special attributes in window 'win'.	*/
/****************************************************************/

void	wstandend(win)
  WINDOW	*win;
  {
  win->_attrs &= ~A_STANDOUT;
  } /* wstandend */

/****************************************************************/
/* wcolors() set the forground and background window colors     */
/****************************************************************/
void  wsetcolors(win, screen)
  WINDOW	*win;
  int   	screen;
  {
  win->_colors = ((screen & 0xf000) >> 12) | (screen & 0xf00); 
  win->_attrs |= 0x8000;
/*  _cursessetcolor(win->_colors); */
  }

/****************************************************************/
/* Attrset() sets the attributes as specified in stdscr.	*/
/****************************************************************/

void	attrset(attrs)
  int attrs;
  {
  stdscr->_attrs = attrs & ATR_MSK;
  } /* attrset */

/****************************************************************/
/* Attron() sets the specified attribute(s) in stdscr.		*/
/****************************************************************/

void	attron(attrs)
  int		 attrs;
  {
  stdscr->_attrs |= (attrs & ATR_MSK);
  } /* attron */

/****************************************************************/
/* Attroff() clears the specified attribute(s) in stdscr.	*/
/****************************************************************/

void	attroff(attrs)
  int		 attrs;
  {
  stdscr->_attrs &= (~attrs & ATR_MSK);
  } /* attroff */

/****************************************************************/
/* Standout() starts standout mode in stdscr.			*/
/****************************************************************/

void	standout()
  {
  stdscr->_attrs = A_STANDOUT;
  } /* standout */

/****************************************************************/
/* Standend() clears all special attributes in stdscr.		*/
/****************************************************************/

void	standend()
  {
  stdscr->_attrs &= ~A_STANDOUT;
  } /* standend */

/****************************************************************/
/* setcolors() set the forground and background window colors   */
/*           of stdscr
/****************************************************************/
void  setcolors(fore, back)
  int   	fore, back;
  {
   wsetcolors(stdscr, fore, back);
  }
